package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.sm.dto.CPRSMessageStatusDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class CPRSMessageUtils {

	private static final Log log = LogFactory.getLog(CPRSMessageUtils.class);
	
	public static Collection<CPRSMessageStatusDTO> getCPRSMessageStatus(List<Object[]> tiuNoteList){
		List cprsNotesList = new ArrayList();
		for(Object[] tiuNoteObj:tiuNoteList)
		{	
			CPRSMessageStatusDTO cprsMessageDto = new CPRSMessageStatusDTO();
			cprsMessageDto.setCreatedDate(tiuNoteObj[0]!=null?tiuNoteObj[0].toString():"");
			cprsMessageDto.setFirstName(tiuNoteObj[1]!=null?tiuNoteObj[1].toString():"");
			cprsMessageDto.setLastName(tiuNoteObj[2]!=null?tiuNoteObj[2].toString():"");
			cprsMessageDto.setErrorCode(tiuNoteObj[3]!=null?"FAILED":"SUCCESS");
			cprsNotesList.add(cprsMessageDto);
		}
		return cprsNotesList;
	}
	
	public static Collection<CPRSMessageStatusDTO> getFailedCPRSMessages(List<Object[]> tiuNoteList){
		List cprsFailedAlerts = new ArrayList();
		for(Object[] tiuNoteObj:tiuNoteList)
		{	
			CPRSMessageStatusDTO cprsMessageDto = new CPRSMessageStatusDTO();
			cprsMessageDto.setCreatedDate(tiuNoteObj[0]!=null?tiuNoteObj[0].toString():"");
			cprsMessageDto.setMessageId(tiuNoteObj[1]!=null?tiuNoteObj[1].toString():"");
			cprsMessageDto.setTriageGroupName(tiuNoteObj[2]!=null?tiuNoteObj[2].toString():"");
			cprsMessageDto.setFirstName(tiuNoteObj[3]!=null?tiuNoteObj[3].toString():"");
			cprsMessageDto.setLastName(tiuNoteObj[4]!=null?tiuNoteObj[4].toString():"");
			cprsMessageDto.setErrorCode(tiuNoteObj[5]!=null?tiuNoteObj[5].toString():"");
			cprsFailedAlerts.add(cprsMessageDto);
		}
		return cprsFailedAlerts;
	}
	
	
	public static String getErrorMessage(String errorReason){
		try{
		if(errorReason!=null){
			return errorReason.substring(0,errorReason.indexOf('^'));	
		}else{
			return null;
		}
		}catch(Exception e1){
			if(log.isErrorEnabled()){
				log.error("An Error Occured while parsing CPRS error message"+e1);
			}
			return errorReason;
		}
	}
}
