package gov.va.med.mhv.sm.util;

public class AttachmentUtils {

	 private static final float KBYTES = 1024f;
	 private static final float MBYTES = KBYTES * KBYTES;
	 private static final float GBYTES = MBYTES * KBYTES;
	 
    public static String displayBytesSize(final long n) {
        final String size;
        final long abs = Math.abs(n);
        if(abs < KBYTES) {
            size = n + " bytes";
        } else if(abs < MBYTES) {
            size = String.format("%.2f", n / KBYTES) + " KB";
        } else if(abs < GBYTES) {
            size = String.format("%.2f", n / MBYTES) + " MB";
        } else {
            return String.format("%.2f", n / GBYTES) + " GB";
        }
        return size;
    }
    
	public static String getAttachmentNameWithSize(String actualText){
		if(actualText!=null){
			return actualText.substring(actualText.indexOf('^')+1,actualText.length());	
		}else{
			return null;
		}
	}
	
	//Returns the Ien from the actual Text delimitted by '^'
	public static String getAttachmentId(String actualText){
		if(actualText!=null){
			return actualText.substring(0,actualText.indexOf('^'));	
		}else{
			return null;
		}
	}
	
	//Returns the First part of String delimitted by '^'
	public static String getFirstPartOfString(String actualText){
		if(actualText!=null){
			return actualText.substring(0,actualText.indexOf('^'));	
		}else{
			return null;
		}
	}
	
	// Returns the Second part of String delimitted by '^'
	public static String getSecondPartOfString(String actualText){
		if(actualText!=null){
			return actualText.substring(actualText.indexOf('^')+1,actualText.length());	
		}else{
			return null;
		}
	}
}
