package gov.va.med.mhv.sm.util;

public class ADUtil {
	
	/* To Prevent LDAP Injection.
	 * Escaping the LDAP search by account name(userName)
	 */
	public static String escapeLDAPSearch(String userName) {
	       StringBuffer strBuffer = new StringBuffer(); 
	       for (int i = 0; i < userName.length(); i++) {
	           char curChar = userName.charAt(i);
	           switch (curChar) {
	               case '\\':
	            	   strBuffer.append("\\\\5c");
	                   break;
	               case '*':
	            	   strBuffer.append("\\\\2a");
	                   break;
	               case '(':
	            	   strBuffer.append("\\\\28");
	                   break;
	               case ')':
	            	   strBuffer.append("\\\\29");
	                   break;
	               case '\u0000': 
	            	   strBuffer.append("\\\\00"); 
	                   break;
	               default:
	            	   strBuffer.append(curChar);
	           }
	       }
	       return strBuffer.toString();
	   }
}
