package gov.va.med.mhv.sm.thread;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class CacheSMDomainHandler {
	private static final Log log = LogFactory.getLog(CacheSMDomainHandler.class);

	public static ThreadLocal<CacheSMDomainEntry> instance = new ThreadLocal<CacheSMDomainEntry>() {
		 protected synchronized CacheSMDomainEntry initialValue() {
			 if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] initialValue called " );
			 return null;
         }
    };
	
    public static CacheSMDomainEntry getInstance() {
    	if(CacheSMDomainHandler.instance.get()==null) {
    		if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] getInstance called " );
                synchronized(instance) {
            	CacheSMDomainEntry entry = new CacheSMDomainEntry();
            	CacheSMDomainHandler.instance.set(entry);
            }
        }
        return (CacheSMDomainEntry)CacheSMDomainHandler.instance.get();
    }
    
    public static void resetInstance() {
    	if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] resetInstance called " );
    	getInstance().setApplication(null);
    }
    
}  
