package gov.va.med.mhv.sm.service.response.messages;

import gov.va.med.mhv.foundation.service.response.BaseServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.CoreMessages;
import gov.va.med.mhv.foundation.service.response.messages.Severity;
import gov.va.med.mhv.foundation.service.response.messages.translation.ExceptionMessageTranslator;
import gov.va.med.mhv.foundation.util.AssertionUtils;

import java.util.HashSet;
import java.util.Set;

import org.springframework.dao.DataAccessException;

public class SmExceptionMessageTranslator implements ExceptionMessageTranslator {


	public static final String DATABASE_EXCEPTION_KEY = "database.exception";
	public static final String ILLEGAL_ARGUMENT_EXCEPTION_KEY = 
		"illegal.argument.exception";
	public static final String ILLEGAL_STATE_EXCEPTION_KEY = 
		"illegal.state.exception";
	
	public static final Set<String> EXCEPTION_ERRORS = getExceptionErrors();
	
	private static Set<String> getExceptionErrors() {
		Set<String> errors = new HashSet<String>();
		errors.add(DATABASE_EXCEPTION_KEY);
		errors.add(ILLEGAL_ARGUMENT_EXCEPTION_KEY);
		errors.add(ILLEGAL_STATE_EXCEPTION_KEY);
		return errors;
	}
	
	/**
	 * @see gov.va.med.mhv.foundation.service.response.messages.translation.
	 * ExceptionMessageTranslator
	 */
	public void translateException(BaseServiceResponse response,
		Exception exception) 
	{
		if (AssertionUtils.isAssignableFrom(exception, DataAccessException.
			 class)) 
		{
			Object[] inserts = {exception.getMessage()};
			response.addMessage(Severity.ERROR, DATABASE_EXCEPTION_KEY, 
				inserts);
		} else if (AssertionUtils.isAssignableFrom(exception, 
				IllegalArgumentException.class)) {
			Object [] inserts = {exception.getMessage()};
			response.addMessage(Severity.ERROR, ILLEGAL_ARGUMENT_EXCEPTION_KEY, 
				inserts);
		} else if (AssertionUtils.isAssignableFrom(exception, 
				IllegalStateException.class))
		{
			Object [] inserts = {exception.getMessage() };
			response.addMessage(Severity.ERROR, ILLEGAL_STATE_EXCEPTION_KEY, 
				inserts);
		} else {
			response.addError(CoreMessages.UNKNOWN_ERROR);
		}
	}
	
}
