package gov.va.med.mhv.sm.service.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.AddresseeDao;
import gov.va.med.mhv.sm.dao.MessageDao;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.TriageRelationDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.RelationshipManagementService;
import gov.va.med.mhv.sm.service.SendMessageService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriageGroupServiceImpl implements TriageGroupService {

	private TriageGroupDao triageGroupDao;
	private TriageRelationDao triageRelationDao;
	private UserDao userDao;
	private MessageDao messageDao;
	private AddresseeDao addresseeDao;
	private SurrogateDao surrogateDao;
	private SendMessageService sendMessageService;
	private RelationshipManagementService relationshipManagementService;
	private PatientBlockedService patientBlockedService;

	private static final Log log = LogFactory.getLog(TriageGroupServiceImpl.class);


	public CollectionServiceResponse<TriageGroup> getTriageGroups() {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getTriageGroupsAllActive());
		return response;
	}

	public CollectionServiceResponse<TriageGroup> getTriageGroupsForStation(String stationNo) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getTriageGroupsForStation(stationNo));
		return response;
	}


	public ServiceResponse<TriageGroup> findTriageGroupById(Long id) {
		Precondition.assertNotNull("id", id);
		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		response.setPayload(triageGroupDao.findById(id));
		return response;
	}

	public ServiceResponse<TriageGroup> findTriageGroupByName(String name){

		Precondition.assertNotBlank("name", name);

		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		response.setPayload(triageGroupDao.findTriageGroupByName(name));
		return response;

	}

	public ServiceResponse<TriageGroup> findActiveTriageGroupByName(String name){
		Precondition.assertNotBlank("name", name);
		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		response.setPayload(triageGroupDao.findActiveTriageGroupByName(name));
		return response;
	}

	public ServiceResponse<TriageGroup> getRelationsForTriageGroup(TriageGroup tg){
		Precondition.assertNotNull("triageGroup", tg);
		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		triageGroupDao.fleshRelations(tg);
		response.setPayload(tg);
		return response;
	}


	public ServiceResponse<TriageGroup> getCliniciansForTriageGroup(TriageGroup tg){
		Precondition.assertNotNull("triageGroup", tg);
		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		triageGroupDao.getCliniciansForTriageGroup(tg);
		response.setPayload(tg);
		return response;
	}

	public ServiceResponse<TriageGroup> getSMClinicsForTriageGroup(Long triageGroupId){
		ServiceResponse<TriageGroup> response = new ServiceResponse<TriageGroup>();
		response.setPayload(triageGroupDao.getSMClinicsForTriageGroup(triageGroupId));
		return response;
	}

	public ServiceResponse<Boolean> savePatientManualAssociation(Long triageGroupId, Patient patient){
		Precondition.assertNotNull("triageGroupId", triageGroupId);
		Precondition.assertNotNull("patient", patient);

		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		List relationObj = triageRelationDao.getRelationId(triageGroupId, patient.getId().toString());

		if(relationObj!=null && relationObj.size()!=0){
			if(log.isInfoEnabled()){
				log.info("[<<<<<202-A>>>>Patient "+patient.getId()+" Relationship Exists..."+relationObj.get(0));
			}
			try{
				Long relationId = ((BigDecimal)relationObj.get(0)).longValue();
				if(relationId!=null){
					TriageRelation triageRelation2 = triageRelationDao.findById(relationId);
					triageRelation2.setActive(true);
					TriageRelation updatedTR = triageRelationDao.save(triageRelation2);
					relationshipManagementService.updatePatientTriageMap(patient, updatedTR);
					if(log.isInfoEnabled()){
						log.info("Successfuly Re-Activated the triage group relationship for patient.."+patient.getId());
					}
					response.setPayload(Boolean.TRUE);

				}
			}catch(Exception e){
				if(log.isErrorEnabled()){
					log.error("SavePatientManualAssociation Error.."+e);
					log.error("Patient->"+patient.getId());
					log.error("TriageGroup->"+triageGroupId);
				}
				response.setPayload(Boolean.FALSE);
			}
		}else{
			if(log.isInfoEnabled()){
				log.info("[<<<<<202-B>>>>Patient "+patient.getId()+"^"+patient.getName()+" Not exists in Triage Relation...");
			}
			TriageGroup triageGroup = triageGroupDao.getTriageGroupAndRelations(triageGroupId);
			if(log.isInfoEnabled()){
				log.info(">>>>>>>>>>>>>>>>Triage Group Name...."+triageGroup.getName());
				log.info("<<<<<<<<<<<<<<<<Triage Group Relation..."+triageGroup.getRelations());
				log.info("Patient "+patient.getId()+" Relationship Doesn't Exists...");
			}
			TriageRelation tr1=new TriageRelation();
	   	 	String patientNssn = patient.getNssn() !=null ? patient.getNssn().toUpperCase() : "";
	   	 	String patientDob = patient.getDob()!=null?DateUtils.getEnglishDate(patient.getDob()):"";
			tr1.setName(patient.getName()+" (SSN:"+patientNssn+")(DOB: "+patientDob+")(Reassigned)");
			tr1.setRelationType(RelationTypeEnum.PATIENT);
			tr1.setVistaIen(patient.getId().toString());
			tr1.setStationNumber(triageGroup.getVistaDiv());
			triageGroup.addRelation(tr1);
			TriageGroup updatedTriageGroup = triageGroupDao.save(triageGroup);

			List<TriageRelation> triageRelation = triageRelationDao.getTriageGroupRelationsForPatient(patient);

			List updateRelationObj = triageRelationDao.getRelationId(triageGroupId, patient.getId().toString());
			if(updateRelationObj!=null && updateRelationObj.size()!=0){
				try{
					Long relationId = ((BigDecimal)updateRelationObj.get(0)).longValue();

					if(relationId!=null){
						TriageRelation triageRelation2 = triageRelationDao.findById(relationId);
						relationshipManagementService.updatePatientTriageMap(patient, triageRelation2);
						response.setPayload(Boolean.TRUE);
					}
				}catch(Exception e){
					if(log.isErrorEnabled()){
						log.error("SavePatientManualAssociation Error.."+e);
						log.error("Patient->"+patient.getId());
						log.error("TriageGroup->"+triageGroupId);
					}
					response.setPayload(Boolean.FALSE);
				}
			}
		}
		return response;
	}


	public SMClinicsTriageMap getActiveSMClinicByTriageGroup(Long triageGroupId){
		return getTriageGroupDao().getActiveSMClinicByTriageGroup(triageGroupId);
	}


	public TreeSet<String> getAllActiveSMClinicsCPRSTitles(){
		return getTriageGroupDao().getAllActiveSMClinicsCPRSTitles();

	}

	public ServiceResponse deleteTriageRelation(TriageRelation relation) {
		ServiceResponse response = new ServiceResponse();
		this.getTriageRelationDao().delete(relation.getId());
		return response;
	}

	public CollectionServiceResponse<Surrogate> getCliniciansWithSurrogate(TriageGroup tg) {
		CollectionServiceResponse<Surrogate> response = new CollectionServiceResponse<Surrogate>();
		response.setCollection(getSurrogateDao().findClinicansWithTriageGroupSurrogate(tg.getId()));
		return response;
	}

	public CollectionServiceResponse<Message> getOpenMsgsForTriageGroup(TriageGroup tg) {
		CollectionServiceResponse<Message> response = new CollectionServiceResponse<Message>();
		response.setCollection(getTriageGroupDao().getOpenMsgsForTriageGroup(tg));
		return response;
	}

	public CollectionServiceResponse<Message> getAssignedMsgsForTriageGroup(TriageGroup tg, List userList) {
		CollectionServiceResponse<Message> response = new CollectionServiceResponse<Message>();
		response.setCollection(getTriageGroupDao().getAssignedMsgsForTriageGroup(tg,userList));
		return response;
	}


	/*
	 * The following method used while delete a triage group, the system reassign all the opened and assigned messages
	 * to the selected member in the dropdown, creating addressee for the selected member.
	 * The selected member can go and complete it before admin try to delete
	 * a triage group again.
	 * @see gov.va.med.mhv.sm.service.TriageGroupService#reassignAllMessagesToMember(java.util.List, java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public void reassignAllMessagesToMember(List<Message> messageList, Long reassignMemberId) {
		Addressee addressee;
		Clinician clinician = getUserDao().findClinicianById(reassignMemberId);

		// Setting the assignee for each and every message and create addressee.
		for(Message msg: messageList){
			Message message = (Message)getMessageDao().findById(msg.getId());
			msg.setAssignedTo(clinician);
			msg.setStatus(ClinicianStatusEnum.INPROCESS);
			this.getMessageDao().save(msg);
			addressee = getAddresseeDao().getAddresseeForUser(reassignMemberId, message.getId());
			if(addressee == null){
				getSendMessageService().addressMessage(message, clinician, SystemFolderEnum.INBOX, false,false);
			}
	    }
	}


	/* The following method used while removed the existing member from the triage group, the system reassign all assigned messages
	 * for the removed member and to the selected member in the dropdown, creating addressee for the selected member.
	 * @see gov.va.med.mhv.sm.service.TriageGroupService#reassignAllMessagesToMember(java.util.List, java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public void reassignMessagesToMember(List<Message> messageList, Long reassignMemberId) {
		Set threadIds = new HashSet();
		Addressee addressee;
		Clinician clinician = getUserDao().findClinicianById(reassignMemberId);

		// Setting the assignee for each and every message
		for(Message msg: messageList){
			Message message = (Message)getMessageDao().findById(msg.getId());
			msg.setAssignedTo(clinician);
			this.getMessageDao().save(msg);

			threadIds.add(message.getThread().getId());
	    }

		List<Message> listOfNonCompletedMessagesByThreadIds = getMessageDao().getMessagesByThreadIds(threadIds);
		for(Message msgByThreadId: listOfNonCompletedMessagesByThreadIds){
			addressee = getAddresseeDao().getAddresseeForUser(reassignMemberId, msgByThreadId.getId());

			// Creates the addressee for a particular message
			if(addressee == null){
				getSendMessageService().addressMessage(msgByThreadId, clinician, SystemFolderEnum.INBOX, false,false);
			}else{
				if(log.isInfoEnabled()){
					log.info("*********** addressee id: " + addressee.getId());
				}
			}
		}
	}

	public CollectionServiceResponse<TriageGroup> getInActiveTriageGroupsForStation(String stationNo) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getInActiveTriageGroupsForStation(stationNo));
		return response;
	}


	public CollectionServiceResponse<TriageRelation> getTriageRelationsForTriageGroup(Long triageGroupId){
		CollectionServiceResponse<TriageRelation> response = new CollectionServiceResponse<TriageRelation>();
		response.setCollection(triageRelationDao.getTriageRelationsForTriageGroup(triageGroupId));
		return response;
	}
	

	public TriageGroupDao getTriageGroupDao() {
		return triageGroupDao;
	}
	public void setTriageGroupDao(TriageGroupDao triageGroupDao) {
		this.triageGroupDao = triageGroupDao;
	}


	public TriageRelationDao getTriageRelationDao() {
		return triageRelationDao;
	}

	public void setTriageRelationDao(TriageRelationDao triageRelationDao) {
		this.triageRelationDao = triageRelationDao;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	public MessageDao getMessageDao() {
		return messageDao;
	}

	public void setMessageDao(MessageDao messageDao) {
		this.messageDao = messageDao;
	}

	public AddresseeDao getAddresseeDao() {
		return addresseeDao;
	}

	public void setAddresseeDao(AddresseeDao addresseeDao) {
		this.addresseeDao = addresseeDao;
	}

	public SendMessageService getSendMessageService() {
		return sendMessageService;
	}

	public void setSendMessageService(SendMessageService sendMessageService) {
		this.sendMessageService = sendMessageService;
	}

	public SurrogateDao getSurrogateDao() {
		return surrogateDao;
	}

	public void setSurrogateDao(SurrogateDao surrogateDao) {
		this.surrogateDao = surrogateDao;
	}

	public RelationshipManagementService getRelationshipManagementService() {
		return relationshipManagementService;
	}

	public void setRelationshipManagementService(
			RelationshipManagementService relationshipManagementService) {
		this.relationshipManagementService = relationshipManagementService;
	}

	/** API **/

	public CollectionServiceResponse<TriageRelation> getRelationsForPatient(Patient p) {
		CollectionServiceResponse<TriageRelation> response = new CollectionServiceResponse<TriageRelation>();
		Collection<TriageRelation> triageRelations = triageRelationDao.getTriageGroupRelationsForPatient(p);
		for(TriageRelation tr : triageRelations) {
			triageRelationDao.fleshTriageGroup(tr);
		}
		response.setCollection(triageRelations);
		return response;
	}


	public CollectionServiceResponse<TriageGroup> getTriageGroupsForPatient(Patient p) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getTriageGroupsForPatient(p));
		return response;
	}

	public CollectionServiceResponse<TriageGroup> getEligibleTriageGroupsForPatient(Patient p) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		Collection<TriageGroup> patientAssociatedGroups = triageGroupDao.getTriageGroupsForPatient(p);
		CollectionServiceResponse<PatientBlockedTriageGroup> collectionResoponse =patientBlockedService.getPatientBlockedTriageGroupsByPatientId(p.getId());
		Collection<PatientBlockedTriageGroup> patBlockedGroups = collectionResoponse.getCollection();
		for(PatientBlockedTriageGroup blockedTg:patBlockedGroups){
			for(TriageGroup associatedTg:patientAssociatedGroups){
				if(blockedTg.getTriageGroupId().equals(associatedTg.getId())){
					patientAssociatedGroups.remove(associatedTg);
					break;
				}
			}
	    }
		response.setCollection(patientAssociatedGroups);
		return response;
	}


	public CollectionServiceResponse<TriageGroup> getTriageGroupsForPatientByStation(Patient patient,String stationNumber) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getTriageGroupsForPatientByStation(patient, stationNumber));
		return response;
	}

	public CollectionServiceResponse<TriageGroup> getTriageGroupsForClinician(Clinician c) {
		CollectionServiceResponse<TriageGroup> response = new CollectionServiceResponse<TriageGroup>();
		response.setCollection(triageGroupDao.getTriageGroupsForClinician(c));
		return response;
	}

	public PatientBlockedService getPatientBlockedService() {
		return patientBlockedService;
	}

	public void setPatientBlockedService(PatientBlockedService patientBlockedService) {
		this.patientBlockedService = patientBlockedService;
	}


}
