package gov.va.med.mhv.sm.service.impl;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.TermsAndConditionsHistDao;
import gov.va.med.mhv.sm.dao.UserAcceptTermsAndConditionsDao;
import gov.va.med.mhv.sm.model.SMTermsConditionsVerHist;
import gov.va.med.mhv.sm.model.UserAcceptTermsConditionsHist;
import gov.va.med.mhv.sm.service.TermsAndConditionsService;

public class TermsAndConditionsServiceImpl implements TermsAndConditionsService {

	private TermsAndConditionsHistDao termsAndConditionsHistDao;
	private UserAcceptTermsAndConditionsDao userAcceptTermsAndConditionsDao;

	public ServiceResponse<SMTermsConditionsVerHist> getActiveTermsConditionsHistory(){
		ServiceResponse<SMTermsConditionsVerHist> response = new ServiceResponse<SMTermsConditionsVerHist>();
		response.setPayload(getTermsAndConditionsHistDao().getActiveTermsConditionsHistory());
		return response;
	}
	
	
	public ServiceResponse<UserAcceptTermsConditionsHist> getUserAcceptTermsAndConditionsHist(Long termsConditionsVerHistId, Long patientId){
		ServiceResponse<UserAcceptTermsConditionsHist> response = new ServiceResponse<UserAcceptTermsConditionsHist>();
		response.setPayload(getUserAcceptTermsAndConditionsDao().getUserAcceptTermsConditions(termsConditionsVerHistId, patientId));
		return response;
	}
	public ServiceResponse<UserAcceptTermsConditionsHist> createUserAcceptTermsConditionsHist(UserAcceptTermsConditionsHist userAcceptTermsConditionsHist){
		ServiceResponse<UserAcceptTermsConditionsHist> response = new ServiceResponse<UserAcceptTermsConditionsHist>();
		UserAcceptTermsConditionsHist updaetdUserAcceptTermsConditionsHist = getUserAcceptTermsAndConditionsDao().save(userAcceptTermsConditionsHist);
		response.setPayload(updaetdUserAcceptTermsConditionsHist);
		return response;
	}

	public TermsAndConditionsHistDao getTermsAndConditionsHistDao() {
		return termsAndConditionsHistDao;
	}

	public void setTermsAndConditionsHistDao(
			TermsAndConditionsHistDao termsAndConditionsHistDao) {
		this.termsAndConditionsHistDao = termsAndConditionsHistDao;
	}

	public UserAcceptTermsAndConditionsDao getUserAcceptTermsAndConditionsDao() {
		return userAcceptTermsAndConditionsDao;
	}

	public void setUserAcceptTermsAndConditionsDao(
			UserAcceptTermsAndConditionsDao userAcceptTermsAndConditionsDao) {
		this.userAcceptTermsAndConditionsDao = userAcceptTermsAndConditionsDao;
	}

}
