package gov.va.med.mhv.sm.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.ReAssignFacilityDao;
import gov.va.med.mhv.sm.dao.ReAssignMessageDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.PatientReassignFacility;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;
import gov.va.med.mhv.sm.service.ReAssignMessageService;



public class ReAssignMessageServiceImpl implements ReAssignMessageService{

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ReAssignMessageServiceImpl.class);

	private ReAssignMessageDao reAssignMessageDao;
	private TriageGroupDao		triageGroupDao;
	private FacilityDao		facilityDao;
	private ReAssignFacilityDao reAssignFacilityDao;

	
	public ServiceResponse<ReAssignMessageHistory> createMessageReceivedHistory(Long secureMessageId,Long triageGroupId,Date createdDate,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.MESSAGE_RECEIVED, "Unassigned", null, null, null, userId, createdDate,true);
	}

	public ServiceResponse<ReAssignMessageHistory> createMessageAutoAssignedHistory(Long secureMessageId,Long triageGroupId,Long userId,String assignedTo){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.SYSTEM_AUTO_ASSIGN, "In Process", "System", assignedTo, null, userId,null,true);
	}
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageWithInTeamHistory(Long secureMessageId,Long triageGroupId,String assignedBy,Long userId,String assignedTo){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.REASSIGN_WITHIN_TG, "In Process", assignedBy, assignedTo, null, userId,null,true);
	}
	
	public ServiceResponse<ReAssignMessageHistory> createCompletedMessageHistory(Long secureMessageId,Long triageGroupId,Long userId,String completedBy){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.MESSAGE_COMPLETION, "Completed", null, null, completedBy, userId,null,true);
	}
	
	
	public ServiceResponse<ReAssignMessageHistory> createEscalatedMessageHistory(Long secureMessageId,Long triageGroupId,String messageStatus,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.MESSAGE_ESCALATION, messageStatus, null, null, null, userId,null,true);
	}

	public ServiceResponse<ReAssignMessageHistory> createAutoAssociatedPatientTGHistory(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, reAssignTriageGroupId, ReAssignMessageActionEnum.PROVIDER_ASSOCIATE_PATIENT_TO_GROUP, "Unassigned", null, null, null, userId, null,true);
	}
	
	public ServiceResponse<ReAssignMessageHistory> createEmailNotificationSentHistory(Long secureMessageId,Long triageGroupId,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, null, ReAssignMessageActionEnum.EMAIL_NOTIFICATION_SENT_TO_ADMINS, "In Process", null, null, null, userId, null,true);
	}

	
	public String getVisnAndFacilityByTriageGroup(Long triageGroupId){

		Object[] visnFacilityName = (triageGroupDao.getVisnAndFaciltiyByTriageGroup(triageGroupId)).get(0);
		StringBuffer triageGroupFullName=new StringBuffer();
		if(visnFacilityName!=null){
			if(visnFacilityName[0]!=null)
				triageGroupFullName.append(visnFacilityName[0]).append("/ Facility ");
			if(visnFacilityName[1]!=null)
					triageGroupFullName.append(visnFacilityName[1]).append("/ ");
			if(visnFacilityName[2]!=null)
					triageGroupFullName.append(visnFacilityName[2]);
		}
		return triageGroupFullName.toString();
	}

	private ServiceResponse<ReAssignMessageHistory> updateReassignHistory(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId,
																		  ReAssignMessageActionEnum action,String messageStatus, String assignedBy, 
																		  String assignedTo, String completedBy, Long userId,Date createdDate,boolean active){
		Precondition.assertNotNull("secureMessageId", secureMessageId);
		Precondition.assertNotNull("triageGroupId", triageGroupId);
		if(log.isInfoEnabled()){
			log.info("<<<<<301>>>>>Reassign Message Update Reassign History....messageId"+secureMessageId+" triageGroupId.."+triageGroupId+"reAssignTriageGroupId..."+reAssignTriageGroupId);
			log.info("Action"+action.getId()+" assignedBy.."+assignedBy+" assigned To..."+assignedTo+" User..."+userId);
		}
		ServiceResponse<ReAssignMessageHistory> response = new ServiceResponse<ReAssignMessageHistory>();
		ReAssignMessageHistory reAssignHistory = new ReAssignMessageHistory();
		try{
			reAssignHistory.setSecureMessageId(secureMessageId);
			reAssignHistory.setReAssignAction(action);
			reAssignHistory.setTriageGroupName(getVisnAndFacilityByTriageGroup(triageGroupId));
			reAssignHistory.setReAssignedStatus(messageStatus);
			if(reAssignTriageGroupId!=null) reAssignHistory.setReAssignedTriageGroupName(getVisnAndFacilityByTriageGroup(reAssignTriageGroupId));
			if(createdDate!=null) reAssignHistory.setCreatedDate(createdDate);
			if(assignedBy!=null) reAssignHistory.setAssignedBy(assignedBy);
			if(assignedTo!=null) reAssignHistory.setAssignedTo(assignedTo);
			if(completedBy!=null) reAssignHistory.setCompletedBy(completedBy);
			reAssignHistory.setActive(active);
			reAssignHistory.setUserId(userId);
			reAssignHistory = reAssignMessageDao.save(reAssignHistory);
			response.setPayload(reAssignHistory);
		}catch(Exception e){
			response.setPayload(null);
			if(log.isErrorEnabled()){
				log.error("Exception while update Reassign Message History for..MessageId.."+secureMessageId+" action.."+action.getId()+" Error.."+e);
			}
		}
		return response;
	}
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherTeamHistory(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, reAssignTriageGroupId, ReAssignMessageActionEnum.REASSIGN_ANOTHER_TG_WITH_IN_FACILITY, "Unassigned", assignedBy, null,null,userId,null,true);
	}
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherStaffWithInFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,String assignedTo,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, reAssignTriageGroupId, ReAssignMessageActionEnum.REASSIGN_ANOTHER_STAFF_WITH_IN_FACILITY, "In Process", assignedBy, assignedTo,null,userId,null,true);
	}

	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherStaffOutsideFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,String assignedTo,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, reAssignTriageGroupId, ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_STAFF_OUTSIDE_FACILITY, "In Process", assignedBy, assignedTo,null,userId,null,true);
	}
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherTGOutsideFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,Long userId){
		return updateReassignHistory(secureMessageId, triageGroupId, reAssignTriageGroupId, ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_TG_OUTSIDE_FACILITY, "Unassigned", assignedBy, null,null,userId,null,true);
	}


	public ServiceResponse<ReAssignMessageHistory> getMsgHistoryByMsgAndAction(Long secureMessageId, ReAssignMessageActionEnum action){
		ServiceResponse<ReAssignMessageHistory> response = new ServiceResponse<ReAssignMessageHistory>();
		response.setPayload(reAssignMessageDao.getMsgHistoryByMsgAndAction(secureMessageId, action));
		return response;
	}

	public Collection<ReAssignMessageHistory> getReAssignMessageHistoryByMessage(Long secureMessageId){
		return reAssignMessageDao.getReAssignMessageHistoryByMessage(secureMessageId);
	}

	public Boolean findMsgReceivedHistoryByMessageId(Long secureMessageId){
		return reAssignMessageDao.findMessageReceivedHistoryByMessage(secureMessageId);
	}
	
	public ServiceResponse<ReAssignMessageHistory> getAutoAssociatedTGHistoryByMessage(Long secureMessageId){
		ServiceResponse<ReAssignMessageHistory> response = new ServiceResponse<ReAssignMessageHistory>();
		response.setPayload(reAssignMessageDao.getAutoAssociatedTGHistoryByMessage(secureMessageId));
		return response;
	}
	
	public ServiceResponse<Boolean> updatePatientReassignFacility(Long reassignFacilityId){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try{
			PatientReassignFacility patientReassignFacility = reAssignFacilityDao.findById(reassignFacilityId);
			patientReassignFacility.setActive(false);
			patientReassignFacility.setModifiedDate(new Date());
			reAssignFacilityDao.update(patientReassignFacility);
			response.setPayload(Boolean.TRUE);
		}catch(Exception e){
			if(log.isErrorEnabled()){
				log.error("Exception while updating Patient Reassign Facility....");
			}
			response.setPayload(Boolean.FALSE);
		}
		return response;
	}
	
	public ServiceResponse<PatientReassignFacility> getPatientReassignFacilityByStationAndPatient(Long stationNumber,Long patientId){
		ServiceResponse<PatientReassignFacility> response = new ServiceResponse<PatientReassignFacility>();
		response.setPayload(reAssignFacilityDao.getPatientReassignFacilityByStationAndPatient(stationNumber,patientId));
		return response;
	}
	
	public ServiceResponse<List<Object[]>> getPatientReassignFacilityByStation(Long stationNumber){
		ServiceResponse<List<Object[]>> response = new ServiceResponse<List<Object[]>>();
		response.setPayload(reAssignFacilityDao.getPatientReassignFacilityByStation(stationNumber));
		return response;
	}
	
	
	public ReAssignMessageDao getReAssignMessageDao() {
		return reAssignMessageDao;
	}

	public void setReAssignMessageDao(ReAssignMessageDao reAssignMessageDao) {
		this.reAssignMessageDao = reAssignMessageDao;
	}

	public TriageGroupDao getTriageGroupDao() {
		return triageGroupDao;
	}

	public void setTriageGroupDao(TriageGroupDao triageGroupDao) {
		this.triageGroupDao = triageGroupDao;
	}
	public FacilityDao getFacilityDao() {
		return facilityDao;
	}
	public void setFacilityDao(FacilityDao facilityDao) {
		this.facilityDao = facilityDao;
	}
	
	public ReAssignFacilityDao getReAssignFacilityDao() {
		return reAssignFacilityDao;
	}

	public void setReAssignFacilityDao(ReAssignFacilityDao reAssignFacilityDao) {
		this.reAssignFacilityDao = reAssignFacilityDao;
	}

	

}
