package gov.va.med.mhv.sm.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

import gov.va.med.mhv.sm.wsclient.pcmm.PatientAssignmentsAtStation;
import gov.va.med.mhv.sm.wsclient.pcmm.PatientSummary;
import gov.va.med.mhv.sm.wsclient.pcmm.PrimaryCareAssignments;
import gov.va.med.mhv.sm.wsclient.pcmm.PrimaryCareTeamAssignment;
import gov.va.med.mhv.sm.wsclient.pcmm.TeamletMember;
import gov.va.med.mhv.sm.wsclient.pcmm.TeamletMembers;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.properties.SMPcmmProperties;
import gov.va.med.mhv.sm.dto.PatientPCPAssignmentDTO;
import gov.va.med.mhv.sm.dto.PatientPCPAssignmentDTO.ProviderSummary;
import gov.va.med.mhv.sm.service.PcmmService;
import gov.va.med.mhv.sm.util.MhvIntegrationUtils;

public class PcmmServiceImpl implements PcmmService {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(PcmmServiceImpl.class);
	private SMPcmmProperties smPcmmProperties;
	private MhvIntegrationUtils mhvIntegrationUtils;
	private static final int CONN_TIMEOUT = 15000;
	private static final int HARD_TIMEOUT = 120000;
	private static final int HTTP_RESPONSE_CODE = 200;

	private String getPcmmEndPointUrl() {
		return getSmPcmmProperties().getPcmmPatientSummaryEndpoint() != null ? getSmPcmmProperties().getPcmmPatientSummaryEndpoint() : null;
	}

	private String getPcmmAuthUser() {
		return getSmPcmmProperties().getPcmmWebAuthUserId() != null ? getSmPcmmProperties().getPcmmWebAuthUserId() : null;
	}

	private String getPcmmAuthPass() {
		return getSmPcmmProperties().getPcmmWebAuthPassword() != null ? getSmPcmmProperties().getPcmmWebAuthPassword() : null;
	}

	private int getPcmmWebConnectionTimeOut() {
		return getSmPcmmProperties().getPcmmWebConnectionTimeout() != null ? Integer.parseInt(getSmPcmmProperties().getPcmmWebConnectionTimeout()): CONN_TIMEOUT;
	}

	private int getPcmmWebSocketTimeOut() {
		return getSmPcmmProperties().getPcmmWebSocketTimeout() != null ? Integer.parseInt(getSmPcmmProperties().getPcmmWebSocketTimeout()): CONN_TIMEOUT;
	}

	private int getPcmmHardTimeOut() {
		return getSmPcmmProperties().getPcmmWebHardTimeout() != null ? Integer.parseInt(getSmPcmmProperties().getPcmmWebHardTimeout()): HARD_TIMEOUT;
	}

	private PatientSummary getPatientAssignments(String icn, String station) {
		Precondition.assertNotNull("icn", icn);
		Precondition.assertNotNull("station", station);
		PatientSummary patientAssignmentsSummary = null;
		final String patientStr = "Patient ICN " + icn + " Station# " + station;
		String patientSummaryEndpointUrl = null;
		String authUser = null;
		String authPass = null;
		if (getSmPcmmProperties() != null) {
			patientSummaryEndpointUrl = getPcmmEndPointUrl();
			authUser = getPcmmAuthUser();
			authPass = getPcmmAuthPass();
		} else {
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->100->SM-PCMM Properties file is null");
			}
		}

		if (patientSummaryEndpointUrl == null)
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->101->PCMM EndPoint url is null");
			}
		if (authUser == null)
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->101A->Auth.UserId is null");
			}
		if (authPass == null)
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->101B->Auth.Pass is null");
			}

		if (patientSummaryEndpointUrl != null && authUser != null && authPass != null) {


			patientSummaryEndpointUrl = patientSummaryEndpointUrl + station + "/icn/" + icn + ".xml";

			long startTime = System.currentTimeMillis();

			CloseableHttpClient httpClient = null;
			CloseableHttpResponse httpResponse = null;
			BufferedReader bufferedReader = null;
			try {
				RequestConfig.Builder requestConfig = RequestConfig.custom();
				requestConfig.setConnectTimeout(getPcmmWebConnectionTimeOut());
				requestConfig.setConnectionRequestTimeout(getPcmmWebConnectionTimeOut());
				requestConfig.setSocketTimeout(getPcmmWebSocketTimeOut());
				HttpClientBuilder builder = HttpClientBuilder.create();
				httpClient = builder.setDefaultRequestConfig(requestConfig.build()).build();
				final HttpGet httpGet = new HttpGet(patientSummaryEndpointUrl);

				httpGet.addHeader("Authorization","Basic " + getMhvIntegrationUtils().getBase64EncryptedAuth(authUser,authPass));
				httpGet.addHeader("accept", "application/xml");

				// Hard timeout starts
				TimerTask task = new TimerTask() {
					@Override
					public void run() {
						if (httpGet != null) {
							httpGet.abort();
							if (log.isInfoEnabled()) {
								log.info("PCMMServiceImpl->101C->SM-PCMM Interface Request aborted due to hard timeout" + patientStr);
							}
						}
					}
				};
				new Timer(true).schedule(task, getPcmmHardTimeOut());
				// Hard timeout ends

				httpResponse = httpClient.execute(httpGet);
				int httpStatusCode = 0;
				if (httpResponse.getStatusLine() != null) {
					httpStatusCode = httpResponse.getStatusLine().getStatusCode();
				}

				if (log.isInfoEnabled()) {
					log.info("PCMMServiceImpl->103->SM-PCMM Interface " + patientStr + " HTTP Response Code: " + httpStatusCode);
				}
				if (httpStatusCode == HTTP_RESPONSE_CODE) {
					try {
						bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
						Class[] patAssignClass = { PatientSummary.class };
						JAXBContext context = JAXBContext.newInstance(patAssignClass);
						Unmarshaller unmarshaller = context.createUnmarshaller();
						Source source = new StreamSource(bufferedReader);
						JAXBElement<PatientSummary> patAssignRoot = unmarshaller.unmarshal(source, PatientSummary.class);
						patientAssignmentsSummary = patAssignRoot.getValue();
						log.info("PCMMServiceImpl->103A->PatientAssignmentsSummary"	+ patientAssignmentsSummary);
						bufferedReader.close();
						httpClient.close();
						httpResponse.close();

					} catch (Exception exp0) {
						if (log.isErrorEnabled()) {
							log.error("PCMMServiceImpl->Exception Inside HTTP STATUS CODE 200 EXCEPTION->" + patientStr);
							exp0.printStackTrace();
						}
					}
					long endTime = System.currentTimeMillis();
					if (log.isInfoEnabled()) {
						log.info("PcmmServieImpl->Elapsed time-> Time taken for PCMM web service call for patient "	+ patientStr + " is " + ((endTime - startTime) / 1000) + " seconds");
					}
				}
			} catch (SSLHandshakeException sslExp) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->SM-PCMM SSL Handshake Exception->" + patientStr);
					sslExp.printStackTrace();
				}
			}

			catch (ClientProtocolException connExp0) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->ClientProtocolException->" + patientStr);
					connExp0.printStackTrace();
				}
			}

			catch (ConnectTimeoutException connExp1) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->ConnectionTimeoutException->" + patientStr);
					connExp1.printStackTrace();
				}
			}

			catch (SocketTimeoutException connExp2) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->SocketTimeoutException->" + patientStr);
					connExp2.printStackTrace();
				}
			}

			catch (MalformedURLException ioExp) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->MalformedURLException->" + patientStr);
					ioExp.printStackTrace();
				}
			}

			catch (IOException ioExp) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->IOException->" + patientStr);
					ioExp.printStackTrace();
				}
			}

			catch (NumberFormatException nfExp) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->NumberFormatException->" + patientStr);
					nfExp.printStackTrace();
				}
			}

			catch (Exception exp) {
				if (log.isErrorEnabled()) {
					log.error("PCMMServiceImpl->SM-PCMM EXCEPTION-> " + patientStr);
					exp.printStackTrace();
				}
			} finally {

				if (log.isInfoEnabled()) {
					log.info("PCMMServiceImpl->Finally Block Closing Connections-> " + patientStr);
				}
				try {
					if (httpClient != null) httpClient.close();
					if (httpResponse != null) httpResponse.close();
					if (bufferedReader != null) bufferedReader.close();
				} catch (IOException ioExp) {
					log.error("PCMMServiceImpl->IOException while closing connections" + ioExp);
				}
			}
		}
		return patientAssignmentsSummary;
	}

	public ServiceResponse<PatientPCPAssignmentDTO> getPatientPCPSummary(String icn, String station) {
		Precondition.assertNotNull("icn", icn);
		Precondition.assertNotNull("station", station);
		String patientStr = "Patient ICN " + icn + " Station# " + station;
		ServiceResponse<PatientPCPAssignmentDTO> serviceResponse = new ServiceResponse<PatientPCPAssignmentDTO>();

		PatientSummary patientSummary = getPatientAssignments(icn, station);
		PatientPCPAssignmentDTO patientPCPassignmentDto = null;

		if (patientSummary != null) {
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->105A->getPatientAssignmentsAtStations() " + patientStr + " size=" + patientSummary.getPatientAssignmentsAtStations() .getPatientAssignmentsAtStation().size());
			}
			if (patientSummary.getPatientAssignmentsAtStations() != null && patientSummary.getPatientAssignmentsAtStations().getPatientAssignmentsAtStation().size() > 0) {
				List<PatientAssignmentsAtStation> patientsAssignmentsStation = patientSummary.getPatientAssignmentsAtStations().getPatientAssignmentsAtStation();

				PatientAssignmentsAtStation patientAssignmentStation = patientSummary.getPatientAssignmentsAtStations().getPatientAssignmentsAtStation().get(0);
				if (patientAssignmentStation != null) {
					try {
						PrimaryCareAssignments primaryAssignments = patientAssignmentStation.getPrimaryCareAssignments();

						List<PrimaryCareTeamAssignment> primaryCareAssignments = primaryAssignments.getPrimaryCareAssignment();
						if (log.isInfoEnabled()) {
							log.info("PCMMServiceImpl->106->PrimaryCareAssignments " + patientStr + " size=" + primaryCareAssignments.size());
						}
						patientPCPassignmentDto = new PatientPCPAssignmentDTO();
						patientPCPassignmentDto.setPatientIcn(icn);
						patientPCPassignmentDto.setStationNumber(station);
						List<ProviderSummary> providerSummarys = new ArrayList<ProviderSummary>();

						for (PrimaryCareTeamAssignment primaryCare : primaryCareAssignments) {
							TeamletMembers teamletMembers = primaryCare.getTeamletMembers();
							List<TeamletMember> teamMembers = teamletMembers.getTeamletMember();
							for (TeamletMember teamMember : teamMembers) {
								try {
									if (teamMember.getTeamRole().getCode() != null && teamMember.getTeamRole().getCode().equalsIgnoreCase("43")) {
										ProviderSummary providerSummary = patientPCPassignmentDto.new ProviderSummary();
										providerSummary.setAssignmentStatus(primaryCare.getAssignmentStatus());
										providerSummary.setProviderIen(teamMember.getStaffContact().getIen().getValue().toString());
										providerSummary.setProviderName(teamMember.getStaffContact().getName().getValue().toString());
										providerSummarys.add(providerSummary);
										if (log.isInfoEnabled()) {
											log.info("PCMMServiceImpl-> " + patientStr + " PCP Provider-> " + teamMember.getStaffContact().getIen().getValue().toString()+ "^" + teamMember.getStaffContact().getName().getValue().toString());
										}
									} else {
										if (log.isInfoEnabled()) {
											log.info("PCMMServiceImpl-> " + patientStr + " Team Role is-> "+ teamMember.getTeamRole().getCode()+ " "+ teamMember.getTeamRole().getName());
										}
									}
								} catch (Exception exp) {
									if (log.isInfoEnabled()) {
										log.info("PCMMServiceImpl->107->Exception in TeamletMember " + patientStr);
										exp.printStackTrace();
									}
								}
							}
						}
						patientPCPassignmentDto.setProviderSummarys(providerSummarys);
					} catch (Exception exp0) {
						if (log.isInfoEnabled()) {
							log.info("PCMMServiceImpl->106->Exception in primaryCareAssignment " + patientStr);
							exp0.printStackTrace();
						}
					}
				} else {
					if (log.isInfoEnabled()) {
						log.info("PCMMServiceImpl->105->PatientAssignmentStation is null " + patientStr);
					}
				}
			}
		} else {
			if (log.isInfoEnabled()) {
				log.info("PCMMServiceImpl->104->PatientAssignmentsAtStations is null "	+ patientStr);
			}
		}
		serviceResponse.setPayload(patientPCPassignmentDto);
		return serviceResponse;
	}

	public SMPcmmProperties getSmPcmmProperties() {
		return smPcmmProperties;
	}

	public void setSmPcmmProperties(SMPcmmProperties smPcmmProperties) {
		this.smPcmmProperties = smPcmmProperties;
	}

	public MhvIntegrationUtils getMhvIntegrationUtils() {
		return mhvIntegrationUtils;
	}

	public void setMhvIntegrationUtils(MhvIntegrationUtils mhvIntegrationUtils) {
		this.mhvIntegrationUtils = mhvIntegrationUtils;
	}

}
