package gov.va.med.mhv.sm.service.impl;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.PatientBlockedHistoryDao;
import gov.va.med.mhv.sm.dao.PatientBlockedTriageGroupDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.PatientBlockedFacilityDao;
import gov.va.med.mhv.sm.model.PatientBlockedHistory;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.TriageGroupService;

public class PatientBlockedServiceImpl implements PatientBlockedService{

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(PatientBlockedServiceImpl.class);

	private PatientBlockedHistoryDao patientBlockedHistoryDao;
	private PatientBlockedTriageGroupDao patientBlockedTriageGroupDao;
	private PatientBlockedFacilityDao patientBlockedFacilityDao;
	private TriageGroupDao triageGroupDao;

	public PatientBlockedTriageGroupDao getPatientBlockedTriageGroupDao() {
		return patientBlockedTriageGroupDao;
	}

	public void setPatientBlockedTriageGroupDao(
			PatientBlockedTriageGroupDao patientBlockedTriageGroupDao) {
		this.patientBlockedTriageGroupDao = patientBlockedTriageGroupDao;
	}

	public PatientBlockedFacilityDao getPatientBlockedFacilityDao() {
		return patientBlockedFacilityDao;
	}

	public void setPatientBlockedFacilityDao(
			PatientBlockedFacilityDao patientBlockedFacilityDao) {
		this.patientBlockedFacilityDao = patientBlockedFacilityDao;
	}

	public PatientBlockedHistoryDao getPatientBlockedHistoryDao() {
		return patientBlockedHistoryDao;
	}

	public void setPatientBlockedHistoryDao(
			PatientBlockedHistoryDao patientBlockedHistoryDao) {
		this.patientBlockedHistoryDao = patientBlockedHistoryDao;
	}

 	public TriageGroupDao getTriageGroupDao() {
    	return triageGroupDao;
    }

    public void setTriageGroupDao(TriageGroupDao triageGroupDao) {
        this.triageGroupDao = triageGroupDao;
	}

	public List<Object[]>  getPatientBlockedCommentsByPatientId(Long patientId){
		return patientBlockedHistoryDao.getPatientBlockedCommentsByPatientId(patientId);
	}

	public void clearPatientBlockedTriageGroupByPatientIdAndStation(Long patientId, Long stationNumber){
		 patientBlockedTriageGroupDao.clearPatientBlockedTriageGroupByPatientIdAndStation(patientId, stationNumber);
	}

	public void clearPatientBlockedFacilityByPatientIdAndStation(Long patientId, Long stationNumber){
		 patientBlockedFacilityDao.clearPatientBlockedFacilityByPatientIdAndStation(patientId, stationNumber);
	}

	public void clearPatientBlockedTriageGroupByPatientId(Long patientId){
		 patientBlockedTriageGroupDao.clearPatientBlockedTriageGroupByPatientId(patientId);
	}

	public List<Object[]>  getPatientBlockedTriageGroupsByPatientIdAndStation(Long patientId,Long stationNumber){
		return patientBlockedTriageGroupDao.getPatientBlockedTriageGroupsByPatientIdAndStation(patientId, stationNumber);
	}

	public List<Object[]>  getPatientBlockedFacilityByPatientIdAndStation(Long patientId,Long stationNumber){
		return patientBlockedFacilityDao.getPatientBlockedFacilityByPatientIdAndStation(patientId, stationNumber);
	}

	public List<Object[]>  getBlockedPatientsDetailsByTriageGroupId(Long triageGroupId){
		return patientBlockedTriageGroupDao.getBlockedPatientsDetailsByTriageGroupId(triageGroupId);
	}



	@SuppressWarnings("unchecked")
	public ServiceResponse<Boolean> updateBlockedPatientTriageGroups(List<PatientBlockedTriageGroup> patientBlockedList){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try
		{
			for(PatientBlockedTriageGroup patientBlockedTg:patientBlockedList){
				if(log.isInfoEnabled()){
					log.info(">>>>>>>>>PatientBlockedServiceImpl->PatientBlockedTG. TgId.."+patientBlockedTg.getTriageGroupId()+"patientId..."+patientBlockedTg.getPatientId()+"^Station.."+patientBlockedTg.getStationNumber());
				}
				PatientBlockedTriageGroup savedBlockedPatientTg = patientBlockedTriageGroupDao.save(patientBlockedTg);
				if(log.isInfoEnabled()){
					log.info(">>>>>>>>>PatientBlockedServiceImpl->PatientBlockedTG saved Successfully...."+savedBlockedPatientTg.getId());
				}
			}
			response.setPayload(Boolean.TRUE);
		}catch(Exception e1){
			if(log.isErrorEnabled()){
				log.error("An Error Occured while Save Blocked Patient Triage Groups...."+e1);
			}
			response.setPayload(Boolean.FALSE);
		}
		return response;
	}

	@SuppressWarnings("unchecked")
	public ServiceResponse<Boolean> updateBlockedPatientHistory(PatientBlockedHistory patientBlockedHistory){
		Precondition.assertNotNull("patientBlockedHistory", patientBlockedHistory);
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try
		{
			patientBlockedHistoryDao.save(patientBlockedHistory);
			response.setPayload(Boolean.TRUE);
		}catch(Exception e2){
			response.setPayload(Boolean.FALSE);
			if(log.isErrorEnabled()){
				log.error("An Error Occured while Save Patient Blocked History...."+e2);
			}
		}
		return response;
	}

	@SuppressWarnings("unchecked")
	public ServiceResponse<Boolean> saveBlockedPatientFacility(PatientBlockedFacility patientBlockedFacility){
		Precondition.assertNotNull("patientBlockedFacility", patientBlockedFacility);
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try
		{
			patientBlockedFacilityDao.save(patientBlockedFacility);
			response.setPayload(Boolean.TRUE);
		}catch(Exception e2){
			response.setPayload(Boolean.FALSE);
			if(log.isErrorEnabled()){
				log.error("An Error Occured while Save Patient Blocked Facility...."+e2);
			}
		}
		return response;
	}


	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedTriageGroup> getPatientBlockedTriageGroupsByPatientId(Long patientId){
		CollectionServiceResponse<PatientBlockedTriageGroup> serviceResponse = new CollectionServiceResponse<PatientBlockedTriageGroup>();
		serviceResponse.addPayloads(patientBlockedTriageGroupDao.getPatientBlockedTriageGroupsByPatientId(patientId));
		return serviceResponse;
	}

	/* This service will get all the TGs blocked from all Facilities.   */
	// get all facilities blocked -
	// get all TGs of each Facility blocked
	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<TriageGroup> getPatientBlockedAllFacilityTriageGroupsByPatientId(Long patientId){

		CollectionServiceResponse<TriageGroup> serviceResponse = new CollectionServiceResponse<TriageGroup>();

		// Get All facilities blocked -
		CollectionServiceResponse<PatientBlockedFacility> collectionResponse = getBlockedFacilitiesByPatientId(patientId);
		Collection<PatientBlockedFacility> patBlockedFacilities = collectionResponse.getCollection();
		for(PatientBlockedFacility blockedFacility:patBlockedFacilities){
			if(log.isInfoEnabled()){
				log.info("<<<<<<<<<<<<<102-->Patient Blocked Triage Group..."+blockedFacility.getStationNumber());
			}
			// Get All TGs in this blocked Facility
			serviceResponse.addPayloads(triageGroupDao.getTriageGroupsForStation(blockedFacility.getStationNumber().toString()));
		}
		return serviceResponse;
	}

	@SuppressWarnings("unchecked")
	public ServiceResponse<PatientBlockedTriageGroup> getPatientBlockedTriageGroupByTgIdAndPatientId(Long triageGroupId,Long patientId){
		ServiceResponse<PatientBlockedTriageGroup> response = new ServiceResponse<PatientBlockedTriageGroup>();
		response.setPayload(patientBlockedTriageGroupDao.getPatientBlockedTriageGroupByTgIdAndPatientId(triageGroupId, patientId));
		return response;
	}

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedTriageGroup> getBlockedPatientsByTriageGroupId(Long triageGroupId){
		CollectionServiceResponse<PatientBlockedTriageGroup> serviceResponse = new CollectionServiceResponse<PatientBlockedTriageGroup>();
		serviceResponse.addPayloads(patientBlockedTriageGroupDao.getBlockedPatientsByTriageGroupId(triageGroupId));
		return serviceResponse;
	}

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilityPatientsByPatientIdAndStation(Long patientId,Long stationNumber){
		CollectionServiceResponse<PatientBlockedFacility> serviceResponse = new CollectionServiceResponse<PatientBlockedFacility>();
		serviceResponse.addPayloads(patientBlockedFacilityDao.getBlockedFacilityPatientsByPatientIdAndStation(patientId,stationNumber));
		return serviceResponse;
	}

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilityPatientsByStation(Long stationNumber){
		CollectionServiceResponse<PatientBlockedFacility> serviceResponse = new CollectionServiceResponse<PatientBlockedFacility>();
		serviceResponse.addPayloads(patientBlockedFacilityDao.getBlockedFacilityPatientsByStation(stationNumber));
		return serviceResponse;
	}

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilitiesByPatientId(Long patientId){
		CollectionServiceResponse<PatientBlockedFacility> serviceResponse = new CollectionServiceResponse<PatientBlockedFacility>();
		serviceResponse.addPayloads(patientBlockedFacilityDao.getBlockedFacilitiesByPatientId(patientId));
		return serviceResponse;
	}

	public List<Object[]>  getBlockedFacilityPatientsDetailsByStation(Long stationNumber){
		return patientBlockedFacilityDao.getBlockedFacilityPatientsDetailsByStation(stationNumber);
	}

	public List<Object[]>  getBlockedFacilityPatientsDetailsByPatientId(Long patientId){
		return patientBlockedFacilityDao.getBlockedFacilityPatientsDetailsByPatientId(patientId);
	}

}
