package gov.va.med.mhv.sm.service.impl;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.ActivityLogDao;
import gov.va.med.mhv.sm.dao.MHVActivityDao;
import gov.va.med.mhv.sm.enumeration.ActivityEnum;
import gov.va.med.mhv.sm.enumeration.EmailNotificationTypeEnum;
import gov.va.med.mhv.sm.enumeration.PerformerTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.LogEntry;
import gov.va.med.mhv.sm.model.MHVActivity;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TiuNoteRecord;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.LoggingService;
import gov.va.med.mhv.sm.thread.CacheSMDomainHandler;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author DNS   GRAHAK
 *
 */
public class LoggingServiceImpl implements LoggingService {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(LoggingServiceImpl.class);

	private ActivityLogDao activityLogDao;
	private MHVActivityDao mhvActivityDao;

	private MHVActivity logMHVActivity(Long userProfileId, String action, Boolean status, String performerType, String detailValue, String activityType, Date completionTime ){
		MHVActivity ma = new MHVActivity(userProfileId,action,status,performerType,detailValue,activityType,completionTime);
		mhvActivityDao.save(ma);
		return ma;
	}
	/**
	 *	REM INSERTING into ACTIVITY
		SET DEFINE OFF;
		INSERT INTO ACTIVITY (ACTIVITY_ID,USER_PROFILE_ID,ACTION,STATUS,PERFORMER_TYPE,DETAIL_VALUE,ACTIVITY_TYPE,COMPLETION_TIME)
		VALUES (GEN_MHV_SEQ.nextval,585024,'Test',1,'System','Health Risk Assessment','Login_Logout',TO_DATE('09-JAN-14','DD-MON-RR'));
	 *
	 * @param userProfileId
	 * @param appName
	 * @return
	 */
	public ServiceResponse<Boolean> logInFromAPI(Long userProfileId, String appName){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		logMHVActivity(userProfileId, "Login",true,"System","Remote System: "+appName,"Login_Logout",new Date());
		response.setPayload(Boolean.TRUE);
		return response;
	}

	private LogEntry log(Long userId, ActivityEnum activity, PerformerTypeEnum performerType,
			Long messageId, Long tiuCreationId, String comments, boolean  status, String activityType){
		//log.info("logging: " + activity + "   userId: " + userId);
		LogEntry le = new LogEntry();
		le.setUserId(userId);
		le.setAction(activity);
		le.setPerformerType(performerType);
		le.setMessageId(messageId);
		le.setTiuCreationId(tiuCreationId);
		le.setDetail(comments);
		le.setStatus(status);
		le.setActivityType(activityType);
		if (CacheSMDomainHandler.getInstance().getApplication() != null) {
			le.setSystem_access(CacheSMDomainHandler.getInstance().getApplication());
		}
		else {
			le.setSystem_access(0l);
		}
		activityLogDao.save(le);
		return le;
	}

	private LogEntry logOptIn(Long userId, ActivityEnum activity, PerformerTypeEnum performerType,
			Long messageId, Long tiuCreationId, String comments, boolean  status, Date termsStatusDateTime){
		LogEntry le = new LogEntry();
		le.setUserId(userId);
		le.setAction(activity);
		le.setPerformerType(performerType);
		le.setMessageId(messageId);
		le.setTiuCreationId(tiuCreationId);
		le.setDetail(CacheSMDomainHandler.getInstance().getApplication()+";"+comments);
		le.setStatus(status);
		le.setCreatedDate(termsStatusDateTime);
		le.setActivityType(null);
		activityLogDao.save(le);
		return le;
	}
	public ServiceResponse<Boolean> optInFromMHV(User user, PerformerTypeEnum performerType, String comments, boolean status, Date termsStatusDateTime){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log.info("optInFromMHV***********getTermsStatusDateTime is null");
		if(termsStatusDateTime==null) termsStatusDateTime=new Date();
		logOptIn(user.getId(), ActivityEnum.OPT_IN , performerType,null,null, comments, status, termsStatusDateTime);
		response.setPayload(Boolean.TRUE);
		return response;

	}

	public ServiceResponse<Boolean> optIn(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.OPT_IN, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> optOut(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.OPT_OUT, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> actionPending(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.ACTION_PENDING_PATIENT, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> sendMessage(User user, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.MESSAGE_SENT, PerformerTypeEnum.SELF, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> sendMessageAsSurrogate(User user, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.SURROGATE_SENT, PerformerTypeEnum.SELF, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> readMessage(User user, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.MESSAGE_READ, PerformerTypeEnum.SELF, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> completeMessage(Clinician c, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(c.getId(), ActivityEnum.MESSAGE_COMPLETED, PerformerTypeEnum.SELF, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> archiveMessage(Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(null, ActivityEnum.MESSAGE_ARCHIVED, PerformerTypeEnum.SYSTEM, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> assignMessage(Clinician c, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(c.getId(), ActivityEnum.MESSAGE_ASSIGNED, PerformerTypeEnum.SELF, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> progressNote(Clinician c, Message m, TiuNoteRecord tiuNoteRecord, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(c.getId(), ActivityEnum.PROGRESS_NOTE, PerformerTypeEnum.SELF, m.getId(), tiuNoteRecord.getId(), comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> blockedPatient(Patient p, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(p.getId(), ActivityEnum.PATIENT_BLOCKED, PerformerTypeEnum.ADMINISTRATOR, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public ServiceResponse<Boolean> unblockPatient(Patient p, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(p.getId(), ActivityEnum.PATIENT_UNBLOCKED, PerformerTypeEnum.ADMINISTRATOR, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the preferences new message notification changes.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> notificationPreferenceChange(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.NOTIFICATION_PREFERENCES_CHANGE, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the preferences clinician inbox view.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> clinicianInboxViewChanges(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.CLINICIAN_INBOXVIEW, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the preferences user Signature Changes
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userSignatureChanges(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.USER_SIGNATURE, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the preferences user surrogate setup
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userSurrogateSetup(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.SURROGATE_SETUP, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}


	/**
	 * Log with the details when completed message status changed to reassign.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> completedMessageReAssignment(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.COMPLETED_MESSAGE_REASSIGNMENT, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}


	/**
	 * Log with the details when a user recalls a message.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> recallMessage(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.RECALLED_MESSAGE, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the change to user networkId or ClinicalUserType
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userInfoChanged(User user, PerformerTypeEnum performerType, String comments, boolean status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.USERINFO_CHANGED, performerType, null, null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}


	/**
	 * Log with the event of an admin reading messages from staff members.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> readStaffMessage(User user, Message m, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(user.getId(), ActivityEnum.MESSAGE_READ_BY_ADMIN, PerformerTypeEnum.ADMINISTRATOR, m.getId(), null, comments, status, null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the event of new Email Notification to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> newEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(userId, ActivityEnum.NEW_MESSAGE_EMAIL_NOTIFICATION, PerformerTypeEnum.SYSTEM, messageId, null, comments, status, emailMessageType.getId().toString());
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the event of ReAssign Email Notification to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> reAssignEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(userId, ActivityEnum.REASSIGN_MESSAGE_EMAIL_NOTIFICATION, PerformerTypeEnum.SYSTEM, messageId, null, comments, status, emailMessageType.getId().toString());
		response.setPayload(Boolean.TRUE);
		return response;
	}

	/**
	 * Log with the event of Facility Admin Email Notification
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> facilityAdminEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(userId, ActivityEnum.FACILITY_ADMIN_EMAIL_NOTIFICATION, PerformerTypeEnum.SYSTEM, messageId, null, comments, status, emailMessageType.getId().toString());
		response.setPayload(Boolean.TRUE);
		return response;
	}
	
	/**
	 * Log with the event of message Sent Error
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> messageSentError(Long userId, Long messageId, String comments, boolean  status){
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		log(userId, ActivityEnum.MESSAGE_SENT_ERROR, PerformerTypeEnum.SYSTEM, messageId, null, comments, status,null);
		response.setPayload(Boolean.TRUE);
		return response;
	}

	public void setMhvActivityDao(MHVActivityDao mhvActivityDao) {
		this.mhvActivityDao = mhvActivityDao;
	}
	public MHVActivityDao getMhvActivityDao() {
		return mhvActivityDao;
	}
	public void setActivityLogDao(ActivityLogDao activityLogDao) {
		this.activityLogDao = activityLogDao;
	}
	public ActivityLogDao getActivityLogDao() {
		return activityLogDao;
	}

}
