package gov.va.med.mhv.sm.service.impl;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.service.FacilityService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;

import java.util.List;

public class FacilityServiceImpl implements FacilityService {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(FacilityServiceImpl.class);

	private FacilityDao facilityDao;

	public CollectionServiceResponse<Facility> getVisnList(){

		CollectionServiceResponse<Facility> response = new CollectionServiceResponse<Facility>();
		List<Facility> l = facilityDao.getVisns();
		response.setCollection(l);
		return response;

	}

	public CollectionServiceResponse<Facility> getFacilityList() {
		CollectionServiceResponse<Facility> response = new CollectionServiceResponse<Facility>();
		response.setCollection(getFacilityDao().getAllFacilities());
		return response;
	}

	public CollectionServiceResponse<Facility> getFacilitiesForParent(
		Facility parent)
	{
		Precondition.assertNotNull("visn", parent);
		CollectionServiceResponse<Facility> response = 
			new CollectionServiceResponse<Facility>();
		response.setCollection(facilityDao.getFacilityByParent(parent));
		return response;
	}

	public CollectionServiceResponse<Facility> getFacilitiesForVisn(
		Facility visn)
	{
		Precondition.assertNotNull("visn", visn);
		CollectionServiceResponse<Facility> response = 
			new CollectionServiceResponse<Facility>();
		response.setCollection(facilityDao.getFacilityByVisn(visn));
		return response;

	}


	public ServiceResponse<Facility> getFacility(Long id) {
		ServiceResponse<Facility> response = new ServiceResponse<Facility>();
		response.setPayload(getFacilityDao().findById(id));
		return response;
	}


	public ServiceResponse<Facility> getVisnForFacility(Facility facility) {
		ServiceResponse<Facility> response = new ServiceResponse<Facility>();
		response.setPayload(getFacilityDao().findById(facility.getVisnId()));
		return response;
	}

	public ServiceResponse<Facility> getFacilityByStationNumber(String station) {
		ServiceResponse<Facility> response = new ServiceResponse<Facility>();
		response.setPayload(getFacilityDao().getFacilityByStationNumber(station));
		return response;
	}

	public FacilityDao getFacilityDao() {
		return facilityDao;
	}
	public void setFacilityDao(FacilityDao facilityDao) {
		this.facilityDao = facilityDao;
	}

}