package gov.va.med.mhv.sm.service.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.DistributionGroupDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.service.DistributionGroupService;
import gov.va.med.mhv.sm.service.response.messages.SmsServiceMessages;

public class DistributionGroupServiceImpl implements DistributionGroupService {

	private static final Log log = LogFactory.getLog(DistributionGroupServiceImpl.class);

	private DistributionGroupDao distributionGroupDao;

	public CollectionServiceResponse<DistributionGroup> getDistributionGroupsForClinician(Clinician c){

		Precondition.assertNotNull("clinician", c);

		CollectionServiceResponse<DistributionGroup> response = new CollectionServiceResponse<DistributionGroup>();
		response.setCollection(distributionGroupDao.getDistributionGroups(c));
		return response;
	}

	public CollectionServiceResponse<DistributionGroup> getDistributionGroupsAndOwnersForClinician(Clinician c){
		Precondition.assertNotNull("clinician", c);

		CollectionServiceResponse<DistributionGroup> response = new CollectionServiceResponse<DistributionGroup>();
		List<DistributionGroup> list = distributionGroupDao.getDistributionGroups(c);
		for(DistributionGroup dg: list) {
			distributionGroupDao.getOwnerForDistributionGroup(dg);
		}
		response.setCollection(list);
		
		return response;
	}
	
	public ServiceResponse<DistributionGroup> createDistributionGroup(Clinician c, DistributionGroup dg){

		Precondition.assertNotNull("distributionGroup", dg);
		Precondition.assertNotNull("distributionGroup", dg.getOwner());
		Precondition.assertNotBlank("distributionGroupName", dg.getName());

		boolean nameAlreadyExist = false;
		DistributionGroup d = new DistributionGroup();
		ServiceResponse<DistributionGroup> response = new ServiceResponse<DistributionGroup>();
		try {
			List<DistributionGroup> dgs = distributionGroupDao.getDistributionGroups(c);
			//Verify if the same distribution group name already exist
			if((dgs != null) && (dgs.size() > 0)){
				for(DistributionGroup dp : dgs){
			  	 	if (dp.getName().equalsIgnoreCase(dg.getName())){
						nameAlreadyExist = true;
			    		response.addError(SmsServiceMessages.DISTRIBUTION_GROUP_NAME_ALREADY_EXIST);
			    	}
				}
			}

			if(nameAlreadyExist){
				response.setPayload(null);
			}else{
				d = distributionGroupDao.save(dg);
				response.setPayload(d);
			}

		} catch (Exception e) {
			if(log.isErrorEnabled()){
				log.error("Expection occured while creating distribution group");
			}
			response.setPayload(null);
			return response;
		}

	        return response;

	}

	public ServiceResponse<Boolean> updateDistributionGroup(DistributionGroup dg){

		Precondition.assertNotNull("distributionGroup", dg);
		Precondition.assertNotNull("distributionGroup", dg.getOwner());
		Precondition.assertNotBlank("distributionGroupName", dg.getName());
		Precondition.assertNotNull("distributionGroupId", dg.getId());

		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try {
			if(dg != null){
				distributionGroupDao.update(dg);
			}
		} catch (Exception e) {
			if(log.isErrorEnabled()){
				log.error("Expection occured while updating distribution group");
			}
			response.setPayload(Boolean.FALSE);
			return response;
		}
			response.setPayload(Boolean.TRUE);
	        return response;

	}

	public ServiceResponse<Boolean> deleteDistributionGroup(DistributionGroup dg){

		Precondition.assertNotNull("distributionGroup", dg);
		Precondition.assertNotNull("distributionGroupId", dg.getId());

		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		try {
			if(dg != null){
				distributionGroupDao.delete(dg.getId());
			}
		} catch (Exception e) {
			if(log.isErrorEnabled()){
				log.error("Expection occured while deletting distribution group");
			}
			response.setPayload(Boolean.FALSE);
			return response;
		}
			response.setPayload(Boolean.TRUE);
	        return response;
	}



	public DistributionGroupDao getDistributionGroupDao() {
		return distributionGroupDao;
	}
	public void setDistributionGroupDao(DistributionGroupDao distributionGroupDao) {
		this.distributionGroupDao = distributionGroupDao;
	}

	public DistributionGroup findById(Long id) {
		DistributionGroup distGroup = distributionGroupDao.findById(id);
	return distGroup;	
	}

}