package gov.va.med.mhv.sm.service.impl;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.util.ConfigurationManager;
import gov.va.med.mhv.sm.model.ContactUs;
import gov.va.med.mhv.sm.service.ContactUsService;
import gov.va.med.mhv.sm.service.EmailService;

import java.util.Properties;

import org.apache.commons.lang.StringUtils;

public class ContactUsServiceImpl implements ContactUsService {
	private static final Properties PROPS = ConfigurationManager.getConfiguration("/smMailCfg.properties");
	/*
	 * CR 2852: Subject of the email should be "Comments from User" rather than the subject
	 * from the Contact Us form
	 */
	private static final String SUBJECT = "Comments from User";
	private static final String NL = "\r\n";

	private EmailService emailService;

	/**
	 * Execute the ContactUs service
	 *
	 * @return VoidServiceResponse
	 */
	public ServiceResponse contactUs(ContactUs contactInfo) {
		/*
		 * If the user doesnt fill out the email address in the contact us form, then the "replyTo" email address will be the "from" address
		 */
		if(StringUtils.isBlank(contactInfo.getEmailAddress())){
			ServiceResponse response = getEmailService().sendMessage(PROPS.getProperty("contactus.from.email"),
					SUBJECT, getMessage(contactInfo), PROPS.getProperty("contactus.to.email"));
			return response;
		}

		/*
		 * If the user fills out the email address in the contact us form, then the "replyTo" email address will be the user's email address
		 */
		else{
			ServiceResponse response = getEmailService().sendMessageWithReplyTo(PROPS.getProperty("contactus.from.email"),
					SUBJECT, getMessage(contactInfo), PROPS.getProperty("contactus.to.email"), contactInfo.getEmailAddress());
			return response;
		}
	}

	private static String getMessage(ContactUs form) {
		StringBuilder messageText = new StringBuilder();

		messageText.append("Message from user: ");

		messageText.append(form.getFirstName()+" ");

		if (!StringUtils.isBlank(form.getMiddleName())) {
			messageText.append(form.getMiddleName()).append(". ");
		}

		messageText.append(form.getLastName());

		messageText.append(" -  MHVID: ");
		messageText.append(form.getMHVId());

		messageText.append(" -  DOB: ");
		messageText.append(form.getDateOfBirth());

		messageText.append(NL).append("Reply to email address: ");
		messageText.append(form.getEmailAddress());

		/*
		 * CR 2853: Phone number should be blank if the user doesnt fill the phone number field
		 */
		messageText.append(NL).append("Reply to phone number: ");
		String phoneNumber = form.getPhoneNumber() == null ? "" : form.getPhoneNumber();
		messageText.append(phoneNumber);

		messageText.append(NL).append("Subject of this Contact: ");
		messageText.append(form.getSubject());

		messageText.append(NL).append(NL).append("Comments: ");
		messageText.append(NL).append(form.getComments());
		messageText.append(NL).append(NL).append(" -----------------------.");

		return messageText.toString();
	}

	public EmailService getEmailService() {
		return emailService;
	}

	public void setEmailService(EmailService emailService) {
		this.emailService = emailService;
	}
}
