package gov.va.med.mhv.sm.service.impl;

import java.util.Collection;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.foundation.service.response.BaseServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;

public abstract class AbstractBaseSMServiceImpl {
	
	private static final Log LOG = LogFactory.getLog(AbstractBaseSMServiceImpl.
		class);

	/**
	 * Override this method with locally defined static Log instance,
	 * such that statements logged in the base class will reference the 
	 * concrete class, rather than the base class.   
	 * @return
	 */
	protected Log getLog() {
		return LOG;
	}
	
	/**
	 * Ensures that a non-null Log instance is returned.
	 * This method uses {@link #getLog()} to obtain a concrete class 
	 * specific Log instance if possible.
	 * This method should typically only be called from base classes and
	 * not from concrete classes. Concrete class should specify their own
	 * LOG instance that is returned from the overriden method 
	 * {@link #getLog()}.  
	 * @return A (non-null) Log instance.
	 */
	protected final Log log() {
		Log log = getLog();
		return (log != null) ? log : LOG;
	}
	
    /**
     * Denotes whether a given service response contains any error messages. 
     * @param response The response to check
     * @return true, when response contains at least one error message; 
     * 	otherwise false.
     */
	protected static boolean hasError(BaseServiceResponse response) {
		return (response != null) && (response.getMessages() != null) 
			&& response.getMessages().hasErrorMessages();
	}
	
    /**
     * Denotes whether a given service response contains a given error 
     * message. 
     * @param response The response to check
     * @param key The error key to check for
     * @return true, when response contains at least one error message; 
     * 	otherwise false.
     */
	@SuppressWarnings("unchecked")
	protected static boolean hasError(BaseServiceResponse response, 
		String key) 
	{
		if (StringUtils.isBlank(key)
		    || (response == null) 
		    || (response.getMessages() == null)
		    || !response.getMessages().hasErrorMessages()) 
		{
			return false;
		}
		for (Message message: (Collection<Message>) response.getMessages().
			getErrorMessages()) // unchecked"
		{
			if (key.equals(message.getKey())) {
				return true;
			}
		}
		return false;
	}


}
