package gov.va.med.mhv.sm.service.exception;


import gov.va.med.mhv.foundation.dao.exceptions.GenericDataAccessException;

/**
 * Data access-agnostic exception indicating that an inconsistency was found
 * by the data access strategy responsible for throwing it.
 * 
 */
public class SendMessageException extends GenericDataAccessException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -53518669103193930L;
	
	private String msgkey;
	

	/**
	 * Instantiate a generic data access exception with the specified message
	 * and throwable exception
	 * @param msg - message to use
	 * @param ex - the root cause
	 */
	public SendMessageException(String msgkey, String msg, Throwable ex) {
		super(msg, ex);
		this.msgkey = msgkey;
	}
	
	/**
	 * Instantiate a generic data access exception using a just a string
	 * as the message
	 * @param msg - message to create the 
	 */
	public SendMessageException(String msgkey) {
		super("Send Message Exception");
		this.msgkey = msgkey;
	}

	public String getMsgkey() {
		return msgkey;
	}
	public void setMsgkey(String msgkey) {
		this.msgkey = msgkey;
	}
	
	
	
}