package gov.va.med.mhv.sm.service;

import java.util.List;
import java.util.TreeSet;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SMClinicsCPRSTitle;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public interface TriageGroupService extends Service{


	public CollectionServiceResponse<TriageGroup> getTriageGroups();

	public CollectionServiceResponse<TriageGroup> getTriageGroupsForStation(String stationNo);

	public ServiceResponse<TriageGroup> findTriageGroupById(Long id);

	public ServiceResponse<TriageGroup> findTriageGroupByName(String name);

	public ServiceResponse<TriageGroup> findActiveTriageGroupByName(String name);

	/**
	 * fetch relations for the passed in triage group
	 *
	 * @param tg
	 * @return
	 */
	public ServiceResponse<TriageGroup> getRelationsForTriageGroup(TriageGroup tg);


	/**
	 * fetch clinicians assigned to triage group
	 *
	 * @param tg
	 * @return
	 */
	public ServiceResponse<TriageGroup> getCliniciansForTriageGroup(TriageGroup tg);

	public ServiceResponse<TriageGroup> getSMClinicsForTriageGroup(Long id);

	public TreeSet<String> getAllActiveSMClinicsCPRSTitles();

	public SMClinicsTriageMap getActiveSMClinicByTriageGroup(Long triageGroupId);

	public ServiceResponse deleteTriageRelation(TriageRelation relations);

	public CollectionServiceResponse<Surrogate> getCliniciansWithSurrogate(TriageGroup tg);

	public CollectionServiceResponse<Message> getOpenMsgsForTriageGroup(TriageGroup tg);

	public CollectionServiceResponse<Message> getAssignedMsgsForTriageGroup(TriageGroup tg, List userList);

	public void reassignAllMessagesToMember(List<Message> messageList, Long reassignMemberId);

	public void reassignMessagesToMember(List<Message> msg, Long id);

	public CollectionServiceResponse<TriageGroup> getInActiveTriageGroupsForStation(String stationNo);

	public ServiceResponse<Boolean> savePatientManualAssociation(Long triageGroupId, Patient patient);

	public CollectionServiceResponse<TriageGroup> getTriageGroupsForPatientByStation(Patient patient,String stationNumber);
	
	/** FOR SM API SERVICE **/

	public CollectionServiceResponse<TriageRelation> getRelationsForPatient(Patient p);
	public CollectionServiceResponse<TriageGroup> getTriageGroupsForPatient(Patient p);
	public CollectionServiceResponse<TriageGroup> getEligibleTriageGroupsForPatient(Patient p);
	
	
	/** FOR CLINICIAN API SERVICE **/
	public CollectionServiceResponse<TriageGroup> getTriageGroupsForClinician(Clinician c);
	
	public CollectionServiceResponse<TriageRelation> getTriageRelationsForTriageGroup(Long triageGroupId);

	

}
