package gov.va.med.mhv.sm.service;

import java.util.Date;
import java.util.List;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.SMWorkloadHistorical;
import gov.va.med.mhv.sm.model.Thread;
import gov.va.med.mhv.sm.model.TiuNotePreview;
import gov.va.med.mhv.sm.model.TiuNoteRecord;

public interface TiuNoteService extends Service{

	/**
	 * Preview the note before creation.  Returns a TiuNotePreview 
	 * detailing the note to be created.  If the Thread has already
	 * been saved as a note, then an addendum will be created.
	 * <p>
	 * <b>NOTE:</b> if a note is in the process of being created then 
	 * the record will be "locked", as noted in the isLocked
	 * member of the TiuNotePreview.  If locked no further action
	 * is available.
	 * <p>
	 * <b>NOTE:</b> when saving as a progress note, all available messages
	 * on the thread will be saved.  Even if the active message in 
	 * the GUI represents a message in the middle of the thread.
	 * <p>
	 * <b>NOTE:</b> be sure to check the error messages of the response
	 * object.  There are a number of reasons where error codes may be
	 * returned unexpectedly.
	 *  <ul>
	 *   <li>There is no patient associated with the thread.</li>
	 *   <li>All messages have already been saved to a progress note.</li>
	 *   <li>The clinician and the patient do not have a facility in common</li>
	 *   <li>The thread has been locked.</li>
	 *  </ul>
	 * <p>
	 * The TiuNotePreview will contain the actual text of the 
	 * proposed note and existing note if available.  But in 
	 * an effort to provide some flexibility to the GUI tier
	 * the messages that make up each piece will be identified
	 * in a respective List<Message>.
	 * 
	 * @param t Thread to be previewed
	 * @param c Clinician wanting to create the note
	 * @return  TiuNotePreview object.
	 */
	public ServiceResponse<TiuNotePreview> getNotePreview(Thread t, Clinician c);
	
	
	
	/**
	 * Save the thread as a progress note in VistA.
	 * 
	 * This is an asynchronous process.  So the record will be
	 * locked until the creation is complete.
	 * 
	 * @param t Thread to use for the note.
	 * @param c Clinician wanting to create the note
	 * @return 
	 */
	
	public ServiceResponse<Boolean> createProgressNote(Thread thread, Clinician c,String[] selectedMessages,TiuNotePreview notePreview);
	//public ServiceResponse<Boolean> createProgressNote(Thread thread, Clinician c,String[] selectedMessages,String tiuNoteTitle);
	

	/**
	 * Save the thread as a progress note in VistA with Workload credit visit date/time.
	 * 
	 * This is an asynchronous process.  So the record will be
	 * locked until the creation is complete.
	 * 
	 * @param t Thread to use for the note.
	 * @param c Clinician wanting to create the note
	 * @return 
	 */
	public ServiceResponse<Boolean> createProgressNoteWithWLCVisit(Long patientId, Long userId, Thread thread, TiuNotePreview notePreview);
	
	/*
	 * Save Workload Capture
	 */
	public ServiceResponse<SMWorkloadHistorical> createWorkload(SMWorkloadHistorical workloadHistorical);
	
		
	/**
	 * Once the note creation is complete this method is to be invoked
	 * in order to unlock the record.  Pass in the conversation id
	 * of the WS.
	 * 
	 * @param conversationId  unique conversactionId used by the webservice 
	 * @param successful      <code>true</code> if the note was successfully saved to VistA
	 * @return
	 */
	public ServiceResponse<Boolean> unlockTiuRecord(String conversationId, boolean successful,String reason);
	
	public String getAttachmentNames(Message message);
	
	public String getVistAPatch11Fields();
	
	public String getVistAPatch11Status();
	
	public ServiceResponse<TiuNotePreview> getNotePreviewSMWeb(Thread thread, Clinician c);
	
	public ServiceResponse<Boolean> createProgressNoteSMWeb(Thread thread, Clinician c,String[] selectedMessages,TiuNotePreview notePreview);
	
	public List<Object[]> getProgressNotesStatusByThreadId(Long threadId);
	
	public ServiceResponse<TiuNoteRecord> getTiuNoteRecordByThreadAndMessageId(Long threadId,Long messageId);
	
	public List<Object[]> getFailedCPRSProgressNotesByStation(String stationNumber);
	
	public ServiceResponse<TiuNotePreview> getNotePreviewForNewMessage(Message message, Clinician clinician, Long patientId);
}
