package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;
import gov.va.med.mhv.sm.model.report.RelationReport;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.PatientRelationshipsResponse;

public interface RelationshipManagementService extends Service {

	
	/**
	 * Update all of the relationships for a single patient.
	 * This is a synchronous call an may take some time depending
	 * on the number of facilities that are defined for the patient.
	 * 
	 * @see syncPatientA(Patient p)
	 * @param p Patient
	 * @return
	 */
	public ServiceResponse<Boolean> syncPatient(Patient p);
	
	/**
	 * Update all of the relationships for a single patient ASYNCHRONOUS.
	 * 
	 * @see syncPatient(Patient)
	 * @param p
	 * @return
	 */
	public ServiceResponse<Boolean> syncPatientA(Patient p);
	
	/**
	 * Update the relationships for the patient. 
	 * 
	 * This is for the asynchronous callback from the ensemble query.
	 * Ensemble will call back once for every station that was queried.
	 * The results in the PatientRelationshipResponse are only for the 
	 * specified station.
	 * 
	 * @param ICN
	 * @param relations
	 * @return
	 */
	public ServiceResponse<Boolean> updatePatientRelationsByStation(String icn, PatientRelationshipsResponse relations);
	
	/**
	 * Update the relationships for the entire SM user base.
	 * This may take a fair amount of time as the patient count
	 * and triage group count increase.
	 * 
	 * @return
	 */
	public ServiceResponse<Boolean> syncAll();
	
	
	/**
	 * Update the relationships for a single triage group.
	 * 
	 * @param tg
	 * @return
	 */
	public ServiceResponse<Boolean> syncTriageGroup(TriageGroup tg);
	
	

	/**
	 * Update the PatientTriageMap relationships for a each patient in Triage Relation.
	 * 
	 * @param Patient, TriageRelation.
	 * @return Boolean
	 */

	public ServiceResponse<Boolean> updatePatientTriageMap(Patient p, TriageRelation tr);

	/**
	 * TODO: 
	 * For staging data only!!! Should not be used in production environment
	 * @param p
	 * @param tr
	 * @return
	 */
	public ServiceResponse<Boolean> addPatientToRelation(Patient p, TriageRelation tr);
	
	
	/**
	 * Build relationships for all patients in a trial run.  Returns a list of 
	 * actions that would be done if this were performed for real.
	 * 
	 * @return
	 */
	public CollectionServiceResponse<RelationReport> relationshipReport();
	
}
