package gov.va.med.mhv.sm.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.PatientReassignFacility;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;

public interface ReAssignMessageService extends Service {

	public ServiceResponse<ReAssignMessageHistory> createMessageReceivedHistory(Long secureMessageId,Long triageGroupId,Date createdDate,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> createMessageAutoAssignedHistory(Long secureMessageId,Long triageGroupId,Long userId,String assignedTo);
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageWithInTeamHistory(Long secureMessageId,Long triageGroupId,String assignedBy,Long userId,String assignedTo);

	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherTeamHistory(Long secureMessageId,Long origTriageGroupId,Long reAssignTriageGroupId, String assignedBy,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherStaffWithInFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,String assignedTo,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherStaffOutsideFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,String assignedTo,Long userId);
		
	public ServiceResponse<ReAssignMessageHistory> createReAssignMessageToAnotherTGOutsideFacility(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId, String assignedBy,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> createCompletedMessageHistory(Long secureMessageId,Long triageGroupId,Long userId,String completedBy);
	
	public ServiceResponse<ReAssignMessageHistory> createEscalatedMessageHistory(Long secureMessageId,Long triageGroupId,String messageStatus,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> createEmailNotificationSentHistory(Long secureMessageId,Long triageGroupId,Long userId);
	
	public Boolean findMsgReceivedHistoryByMessageId(Long secureMessageId);
	
	public ServiceResponse<ReAssignMessageHistory> getMsgHistoryByMsgAndAction(Long secureMessageId,ReAssignMessageActionEnum action);
	
	public Collection<ReAssignMessageHistory> getReAssignMessageHistoryByMessage(Long secureMessageId);
	
	public ServiceResponse<ReAssignMessageHistory> createAutoAssociatedPatientTGHistory(Long secureMessageId,Long triageGroupId,Long reAssignTriageGroupId,Long userId);
	
	public ServiceResponse<ReAssignMessageHistory> getAutoAssociatedTGHistoryByMessage(Long secureMessageId);
	
	public String getVisnAndFacilityByTriageGroup(Long triageGroupId);
	
	public ServiceResponse<Boolean> updatePatientReassignFacility(Long reassignFacilityId);
	
	public ServiceResponse<PatientReassignFacility> getPatientReassignFacilityByStationAndPatient(Long stationNumber,Long patientId);
	
	public ServiceResponse<List<Object[]>> getPatientReassignFacilityByStation(Long stationNumber);
}
