package gov.va.med.mhv.sm.service;


import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.PatientBlockedHistory;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.TriageGroup;


public interface PatientBlockedService extends Service {

	@SuppressWarnings("unchecked")
	public List<Object[]>  getPatientBlockedCommentsByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public void clearPatientBlockedTriageGroupByPatientIdAndStation(Long patientId, Long stationNumber);

	@SuppressWarnings("unchecked")
	public void clearPatientBlockedFacilityByPatientIdAndStation(Long patientId, Long stationNumber);

	@SuppressWarnings("unchecked")
	public void clearPatientBlockedTriageGroupByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public List<Object[]>  getPatientBlockedTriageGroupsByPatientIdAndStation(Long patientId,Long stationNumber);

	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedPatientsDetailsByTriageGroupId(Long triageGroupId);

	@SuppressWarnings("unchecked")
	public ServiceResponse<Boolean> updateBlockedPatientTriageGroups(List<PatientBlockedTriageGroup> patientBlockedList);


	public ServiceResponse<Boolean> updateBlockedPatientHistory(PatientBlockedHistory patientBlockedHistory);

	public ServiceResponse<Boolean> saveBlockedPatientFacility(PatientBlockedFacility patientBlockedFacility);

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedTriageGroup> getPatientBlockedTriageGroupsByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<TriageGroup> getPatientBlockedAllFacilityTriageGroupsByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public ServiceResponse<PatientBlockedTriageGroup> getPatientBlockedTriageGroupByTgIdAndPatientId(Long triageGroupId,Long patientId);

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedTriageGroup> getBlockedPatientsByTriageGroupId(Long triageGroupId);


	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilityPatientsByPatientIdAndStation(Long patientId,Long stationNumber);

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilityPatientsByStation(Long stationNumber);

	@SuppressWarnings("unchecked")
	public CollectionServiceResponse<PatientBlockedFacility> getBlockedFacilitiesByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedFacilityPatientsDetailsByStation(Long stationNumber);

	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedFacilityPatientsDetailsByPatientId(Long patientId);

	@SuppressWarnings("unchecked")
	public List<Object[]>  getPatientBlockedFacilityByPatientIdAndStation(Long patientId,Long stationNumber);


}
