package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SubFolder;


public interface MailboxService extends Service {


	/**
	 * Returns a list of all folders with
	 * message counts and unread counts and
	 * populates the Inbox with the first page
	 * according to the user preferences
	 *
	 * @param u User
	 * @return
	 */
	public ServiceResponse<Patient> getMailbox(Patient p);
	public ServiceResponse<Clinician> getMailbox(Clinician c);

	/**
	 * update the messages counts for the folders already in
	 * the mailbox.  If the Mailbox has not yet been instantiated or
	 * new folders have been created then the
	 * Mailbox will need to be recreated with getMailbox()
	 *
	 * @param p
	 * @return
	 */
	public ServiceResponse<Patient> updateCounts(Patient p);
	public ServiceResponse<Clinician> updateCounts(Clinician c);


	/**
	 * Fetch the first page of messages for the folder.
	 * The messages will be sorted according to the set
	 * filter and sort order set in the folder.
	 *
	 * Note: If the folder is -not- the Inbox then the
	 * filter will be ignored and -all- messages will be
	 * retrieved.
	 *
	 * The first method returns the first page.
	 */
	public ServiceResponse<Folder> getMessages(Folder f);
	public ServiceResponse<Folder> getMessages(Folder f, MessagesPageEnum page);
	public ServiceResponse<Folder> getMessages(Folder f, SearchFormDTO sf);
	public ServiceResponse<Folder> getMessages(Folder f, MessagesPageEnum page, SearchFormDTO sf);


	//Add, rename and delete the user folders
	public ServiceResponse<Boolean> addUserFolder(Folder f);
	public ServiceResponse<Boolean> renameUserFolder(Folder f);
	public ServiceResponse<Boolean> deleteUserFolder(Long folderId);
	
	//SM API
	public ServiceResponse<Patient> getMailbox(Patient p, boolean preloadInbox);
	public ServiceResponse<Clinician> getMailbox(Clinician c, boolean preloadInbox);
	public ServiceResponse<Clinician> getMailbox(Clinician c, boolean preloadInbox, boolean loadViewCounts);
	public int getMessageReminderToday(Long userId);
	
	public int getCPRSAlertsCount(Long userId);
	
}
