/**
 * 
 */
package gov.va.med.mhv.sm.service;

import java.util.Date;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.EmailNotificationTypeEnum;
import gov.va.med.mhv.sm.enumeration.PerformerTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TiuNoteRecord;
import gov.va.med.mhv.sm.model.User;

/**
 * @author DNS   MCCARW
 *
 */
public interface LoggingService extends Service{

	/**
	 * Log a user being opted in
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> optIn(User user, PerformerTypeEnum performerType, String comments, boolean successful);

	/**
	 * Log a user being opted in
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> optInFromMHV(User user, PerformerTypeEnum performerType, String comments, boolean successful,Date date);

	
	/**
	 * Log a user being opted out
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> optOut(User user, PerformerTypeEnum performerType, String comments, boolean successful);
	
	/**
	 * User not Opted In(Action Pending)
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> actionPending(User user, PerformerTypeEnum performerType, String comments, boolean successful);
	
	/**
	 * Log the sending of a message
	 * 
	 * @param user
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> sendMessage(User user, Message m, String comments, boolean  successful);
	
	/**
	 * log a message being sent from a surrogate
	 * 
	 * @param user
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> sendMessageAsSurrogate(User user, Message m, String comments, boolean  successful);
	
	/**
	 * log the reading of a message
	 * 
	 * @param user
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> readMessage(User user, Message m, String comments, boolean  successful);
	
	/**
	 * log the completion of a message
	 * 
	 * @param c
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> completeMessage(Clinician c, Message m, String comments, boolean  successful);
	
	/**
	 * log the archiving of a message
	 * 
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> archiveMessage(Message m, String comments, boolean  successful);
	
	/**
	 * log the assigning of a message
	 * 
	 * @param c
	 * @param m
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> assignMessage(Clinician c, Message m, String comments, boolean  successful);
	
	/**
	 * log the creation of a progress note
	 * 
	 * @param c
	 * @param m
	 * @param tiuNoteRecord
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> progressNote(Clinician c, Message m, TiuNoteRecord tiuNoteRecord, String comments, boolean  successful);
	
	/**
	 * log the blocking of a patient
	 * 
	 * @param p
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> blockedPatient(Patient p, String comments, boolean  successful);
	
	/**
	 * log the unblocking of a patient
	 * 
	 * @param p
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> unblockPatient(Patient p, String comments, boolean  successful);
	
	
	/**
	 * Log with the preferences new message notification changes.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> notificationPreferenceChange(User user, PerformerTypeEnum performerType, String comments, boolean status);

	/**
	 * Log with the preferences clinician inbox view.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> clinicianInboxViewChanges(User user, PerformerTypeEnum performerType, String comments, boolean status);

	/**
	 * Log with the preferences user signature
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userSignatureChanges(User user, PerformerTypeEnum performerType, String comments, boolean status);
	
	/**
	 * Log with the preferences with surrogate setup
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userSurrogateSetup(User user, PerformerTypeEnum performerType, String comments, boolean status);
	
	/**
	 * Log with the details when completed message status changed to reassign.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> completedMessageReAssignment(User user, PerformerTypeEnum performerType, String comments, boolean status);
	
	/**
	 * Log with the change to user networkId or ClinicalUserType
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> userInfoChanged(User user, PerformerTypeEnum performerType, String comments, boolean status);
	
	/**
	 * Log when a user recalls a message
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> recallMessage(User user, PerformerTypeEnum performerType, String comments, boolean status);
	
	/**
	 * Log with the event of an admin reading messages from staff members.
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> readStaffMessage(User user, Message m, String comments, boolean  status);
		
	/**
	 * Log with the event of new Email Notification to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> newEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType);
	
	/**
	 * Log with the event of ReAssign Email Notification to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> reAssignEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType);
	
	/*
	 * Log with the event of ReAssign Email Notification to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> facilityAdminEmailNotification(Long userId, Long messageId, String comments, boolean  status,EmailNotificationTypeEnum emailMessageType);

	/**
	 * Log with the event of message sent Error to the User
	 * @param user
	 * @param performerType
	 * @param comments
	 * @param successful
	 * @return
	 */
	public ServiceResponse<Boolean> messageSentError(Long userId, Long messageId, String comments, boolean  status);
	
	/**
	 * Log to the MHV Activity table
	 * 
	 * @param userProfileId
	 * @param appName
	 * @return
	 */
	public ServiceResponse<Boolean> logInFromAPI(Long userProfileId, String appName);
}
