package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Facility;

public interface FacilityService extends Service{

	/**
	 * Return a list of VISNS for selection
	 * 
	 * @return
	 */
	public CollectionServiceResponse<Facility> getVisnList();
	
	/**
	 * Return all of the Facilities
	 */
	public CollectionServiceResponse<Facility> getFacilityList();
	
	/**
	 * Return the children facilities of the passed in parent facility
	 * @param parent
	 * @return
	 */
	public CollectionServiceResponse<Facility> getFacilitiesForParent(
		Facility parent);
	
	/**
	 * Return the facilities of the given in VISN.
	 * @param visn
	 * @return
	 */
	public CollectionServiceResponse<Facility> getFacilitiesForVisn(
		Facility visn);
	
	/**
	 * Return the Facility with the given ID
	 */
	public ServiceResponse<Facility> getFacility(Long id);
	
		/**
	 * Return the Facility with the given station number
	 */
	public ServiceResponse<Facility> getFacilityByStationNumber(String station);
	
	/**
	 * Return the Facility for the parent VISN of the passed in facility
	 */
	public ServiceResponse<Facility> getVisnForFacility(Facility facility);
}
