package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.TriageGroup;

public interface EscalationService extends Service{

	
	/**
	 * Escalate patient messages that have not been  
	 * completed in (configurable) number of business days. 
	 * 
	 * @return total number of messages that were escalated
	 */
	public ServiceResponse<Integer> escalate();
	
	/**
	 * Get all triage groups that need to be notified that 
	 * messages have just been escalated
	 * 
	 * @return Triage Groups to be notified
	 */
	public CollectionServiceResponse<TriageGroup> getTriageGroupsToNotify();
	
	/**
	 * Send email message notifying triage group that there are messages
	 * that have been escalated
	 * 
	 * @param triageGroup group to be notified
	 * @return number of notifications sent
	 */
	public ServiceResponse notifyTriageGroupOnEscalation(TriageGroup triageGroup);
	
	/**
	 * Send email notification to facility Administrators for those triage messages escalated X number of days
	 * @return Boolean
	 */
	public ServiceResponse<Boolean> notifyFacilityAdminAfterEscalatedXDays();
	
	/*
	 * removeUnassignedAttachments, remove the attachments from table if any of the attachment doesnot have secure message Id.
	 */
	//public void removeUnassignedAttachments();
	

}
