package gov.va.med.mhv.sm.service;

import java.util.List;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;

public interface EmailService extends Service {

	public static final String BAD_EMAIL_ADDRESS = "email.badAddress";
	public static final String EMAIL_SEND_ERROR = "email.sendError";
	public static final String BAD_EMAIL_CONTENT = "email.contentError";
	
	public void sendNewMessageEmailNotification(User user,TriageGroup triageGroup, Message message);
	
	public void sendAssigmentNotification(User u,TriageGroup tg,Message message);
	
	/**
	 * Send email to all current members of the triage group that messages
	 * associated with the triage group have been escalated
	 *
	 * @param tg triage group
	 * @param messages list of messages
	 */
	public void sendEscalationNotification(TriageGroup tg, List<Message> messages);
	
	/**
	 * Execute the SendMessage operation
	 * 
	 * @param from
	 * @param subject
	 * @param message
	 * @param recipient
	 * @return VoidServiceResponse
	 */
	public ServiceResponse sendMessage(String from, String subject, 
        String message, String recipient);

	/**
	 * 
	 * @param from
	 * @param subject
	 * @param message
	 * @param recipient
	 * @param replyTo
	 * @return
	 */
	public ServiceResponse sendMessageWithReplyTo(String from, String subject, 
        String message, String recipient, String replyTo);

	/**
	 * Send email to facility administrators for If the escalated message is exceeded X days
	 * @param tg triage group
	 * @param array of emailAddress
	 * @param days Exceeded.
	 */
	public void sendNotificationToFacilityAdmin(String triageGroupName, String emailAddress, int daysExceeded) ;
	
	public void sendEmailNotificationToFacilityAdmins(Long userId,Long messageId,String triageGroup,Long assignedToStation,Long assignedByStation,String visnName,String[] adminsEmail);
	
}
