package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.model.Clinician;

public interface DistributionGroupService extends Service{

	/**
	 * Returns a list of distribution groups for the given clinician.
	 * @param c    	Clinician 	must
	 * @return      List<DistributionGroup>
	 */
	public CollectionServiceResponse<DistributionGroup> getDistributionGroupsForClinician(Clinician c);


	/**
	 * Creates a distribution group for the given clinician.
	 * @param c    	Clinician 			must
	 * @param dg	DistributionGroup	must
	 * @return      Updated DistributionGroup object
	 * DistributionGroup(dg) name, owner and members must not be null/blank.
	 */
	public ServiceResponse<DistributionGroup> createDistributionGroup(Clinician c, DistributionGroup dg);


	/**
	 * Updates the given distribution group with modified data
	 * @param dg	DistributionGroup	must
	 * @return      Boolean value
	 * DistributionGroup(dg) id, name, owner and members must not be null/blank.
	 */
	public ServiceResponse<Boolean> updateDistributionGroup(DistributionGroup dg);


	/**
	 * Deletes a distribution group and the group members from the database
	 * @param dg	DistributionGroup	must
	 * @return      Boolean value
	 * DistributionGroup(dg) id must not be null/blank.
	 */
	public ServiceResponse<Boolean> deleteDistributionGroup(DistributionGroup dg);

	/**
	 * For API's to populate the owner information. 
	 * @param c
	 * @return
	 */
	public CollectionServiceResponse<DistributionGroup> getDistributionGroupsAndOwnersForClinician(Clinician c);	
	
	/*
	 *  For API's to Search for Distribution Group
	 */
	public DistributionGroup findById(Long id);
}
