package gov.va.med.mhv.sm.service;

import gov.va.med.mhv.foundation.service.Service;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.ad.ADQueryResult;
import gov.va.med.mhv.sm.dto.DiagnosisDTO;
import gov.va.med.mhv.sm.dto.LocationDssUnitsDTO;
import gov.va.med.mhv.sm.dto.PatientEligibilityClassifications;
import gov.va.med.mhv.sm.enumeration.WorkloadCaptureTypeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.ClinicalUserType;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Clinic;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Provider;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMClinic;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMNoteTitle;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Team;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.User;
import gov.va.med.mhv.sm.wsclient.tiusvc.DSSUnit;
import gov.va.med.mhv.sm.wsclient.tiusvc.Diagnosis;
import gov.va.med.mhv.sm.wsclient.tiusvc.ECSProcedure;

public interface AdminService extends Service{

	
	/**
	 * Returns a list of clinical user types that can "classify" a 
	 * clinical user.
	 * @return
	 */
	public CollectionServiceResponse<ClinicalUserType> getClinicalUserTypes();
	
	
	/**
	 * Search vista for a particular user.
	 * 
	 * Returns a list of vista user matching the given names
	 * 
	 * @param lastName   last name for search criteria (required)
	 * @param firstName  first name for search criteria (not required)
	 * @param stationNo  identifies the target vista system (required)
	 * @return
	 */
	public CollectionServiceResponse<User> findVistaClinician(String lastName, String firstName, String stationNo);
	
	/**
	 * Search vista for a particular user based on DUZ
	 * 
	 * @param duz
	 * @param stationNo
	 * @return
	 */
	public CollectionServiceResponse<User> findVistaClinician(String duz, String stationNo);
	
	/**
	 * Search the active directory for the username provided.
	 * If multiple results are found by the search an error is
	 * returned. 
	 * 
	 * @param username  the networkId or sAMAccountName *without* domain
	 * @return
	 */
	public ServiceResponse<ADQueryResult> findADAccount(String username);
	
	
	
	/**
	 * Create a clinician account from the previously obtained
	 * vistaUser and active directory query results.
	 * 
	 * @param stationNo        station no for clinician
	 * @param vistaUser        User from the vista lookup
	 * @param adr              ADQueryResult from the ad query 
	 * @param clinicalUserType ClinicalUserType (can be null)
	 * @param admin            Administrator creating the account
	 * @return                 returns a new administrator 
	 */
	public ServiceResponse<Clinician> createClinicianAccount(String stationNo, User vistaUser, ADQueryResult adr, 
			ClinicalUserType clinicalUserType, Administrator admin);
	
	
	/**
	 * Create a clinician account 
	 * 
	 * @deprecated    replaced by {@link #createClinicianAccount(String,User,ADQueryResult,ClinicalUserType,Administrator)}
	 *                this should only be used directly by staging because logging is not done.
	 * 
	 * @param networkId
	 * @param stationNo
	 * @param firstName
	 * @param lastName
	 * @param email
	 * @param ssn
	 * @param duz
	 * @param clinicalUserType
	 * @param isProvider
	 * @return
	 */
	public ServiceResponse<Clinician> createClinicianAccount(String networkId, String stationNo, String firstName, String lastName,
			String email, String ssn, String duz, ClinicalUserType clinicalUserType, boolean isProvider);
	
	
	/**
	 * Save a Triage Group new/edited
	 * Must have at least 1 clinician identified as member.
	 * 
	 * @param tg  TriageGroup to save
	 * @return    persisted TriageGroup 
	 */
	public ServiceResponse<TriageGroup> saveTriageGroup(TriageGroup tg);
	
	
	/**
	 * Return a list of PCMM providers for Triage Group Relationships.
	 * Station Number and last name must be defined.
	 * 
	 * @param stationNo
	 * @param lastName
	 * @param firstName
	 * @return
	 */
	public CollectionServiceResponse<Provider> searchPcmmProviders(String stationNo, String lastName, String firstName);
	
	
	
	
	/**
	 * Return a PCMM provider by looking up DUZ
	 * 
	 * @param stationNo
	 * @param lastName
	 * @param firstName
	 * @return
	 */
	public ServiceResponse<Provider> getPcmmProvider(String stationNo, String duz);
	
	
	/**
	 * Return a list of Clinics for Triage Group Relationships.
	 * Station Number and (at least partial) clinic name must be defined
	 *  
	 * @param stationNo
	 * @param clinicName
	 * @return
	 */
	public CollectionServiceResponse<Clinic> searchClinics(String stationNo, String clinicName);
	

	/**
	 * Return a list of SM Clinics for Triage Group - Workload Clinic Relationships.
	 * Station Number and (at least partial) clinic name, and credit stop code must be defined
	 *  
	 * @param stationNo
	 * @param clinicName
	 * @param stopCode
	 * @return
	 */
	public CollectionServiceResponse<SMClinic> searchSMClinicsByStopCode(String stationNo, String clinicName,String stopCode);
	

	/**
	 * Return a list of DSS Units 
	 * Station Number, clinicIen, and provider duz
	 *  
	 * @param stationNo
	 * @param clinicIen
	 * @param duz
	 * @return
	 */
	public LocationDssUnitsDTO getDSSUnitsByClinicAndStation(String stationNo, String clinicIen,String duz,String workloadType);
	
	/**
	 * Return a list of ECS Procedures 
	 * 	   
	 * @param stationNo
	 * @param locationIen
	 * @param dssUnitIen
	 * @return
	 */
	public CollectionServiceResponse<ECSProcedure> getECSProcedures(String stationNo, String location,String dssUnit);
		
	/**
	 * Return a list of Problem List 
	 * 	   
	 * @param stationNo, patientIcn
	 * @return
	 */
	public CollectionServiceResponse<Diagnosis> getPatientProblems(String stationNo,Long patientId);
	
	
	/**
	 * Return a list of Diagnosis 
	 * 	   
	 * @param stationNo, diagnosisName
	 * @return
	 */
	public ServiceResponse<DiagnosisDTO> getDiagnosis(String stationNo,String diagnosisName);
	
	
	/**
	 * Return PatientEligibilityClassifications 
	 * 	   
	 * @param stationNo
	 * @param dssUnitIen
	 * @param patientId
	 * @param procDateTime
	 * @return
	 */
	public PatientEligibilityClassifications getPatientEligibilityAndClassification(String stationNo, String dssUnitIen, Long patientId);

	
	/**
	 * Return a list of SM CPRS Titles for Station and documentClass .
	 *  
	 * @param stationNo
	 * @param documentClass
	 * @return
	 */

	public CollectionServiceResponse<SMNoteTitle> getCPRSTIUTitles(java.lang.String station, java.lang.String documentClass);
	
	/**
	 * Return a list of OERR Teams for Triage Group Relationships
	 * Station Number and (at least partial) team name must be defined
	 * 
	 * @param stationNo
	 * @param teamName
	 * @return
	 */
	public CollectionServiceResponse<Team> searchTeams(String stationNo, String teamName);
	
	
	public CollectionServiceResponse<gov.va.med.mhv.sm.wsclient.adminqueriessvc.Patient> getPatientsByOERRTeam(String teamIEN, String station);
	
	public CollectionServiceResponse<gov.va.med.mhv.sm.wsclient.adminqueriessvc.Patient> getPatientsByProvider(String providerIEN, String station);
	
	public CollectionServiceResponse<gov.va.med.mhv.sm.wsclient.adminqueriessvc.Patient> getPatientsByClinic(String clinicIEN, String station);
	
}
