package gov.va.med.mhv.sm.model.report;

import java.util.Comparator;

public class SelectElement implements Comparable {
	private String name;
	private String value;
	
	public SelectElement() {
	}

	public SelectElement(String name, String value) {
		this.name=name;
		this.value=value;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String toString() {
		return "{name: "+name+", value:" + value+"}";
	}

	public int compareTo(Object o) {
		SelectElement se = (SelectElement) o;
		return this.getName().compareToIgnoreCase(se.getName());
	}
	
	/**
	 * Name for Quarter is:  "Quarter 1, 2009" for example.
	 * This transforms it to "2009Quarter 1". For sorting.
	 */
	public static final Comparator<SelectElement> QUARTER_SORTER = new Comparator<SelectElement>() {
		public int compare(SelectElement a, SelectElement b) {
			if(a == null || b == null) return 0;
			
			int aInd = a.getName().indexOf(',');
			int bInd = b.getName().indexOf(',');
			String aKey1 = a.getName().substring(aInd+1);
			String bKey1 = b.getName().substring(bInd+1);
			String aKey2 = a.getName().substring(0,aInd);
			String bKey2 = b.getName().substring(0,bInd);
			
			return  (aKey1+aKey2).compareTo(bKey1+bKey2);
		}
	};
	
}
