package gov.va.med.mhv.sm.model.report;

import gov.va.med.mhv.sm.service.impl.ReportsServiceImpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultKey implements Comparable<ResultKey> {
	
	private String key;
	private String description;
	
	private static final Log log = LogFactory.getLog(ResultKey.class);

	public ResultKey(String key, String description) {
		this.key = key;
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Long getKeyLong() {
		try {
			Long.parseLong(this.key);
		} catch (NumberFormatException e) {
			log.error("Unable to parse long for reporting Id of '" + this.key + "' for " + this.description);
		}
		
		return new Long(this.key);
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( this == obj ) return true;
		if ( ! ( obj instanceof ResultKey) ) return false;
		ResultKey other = (ResultKey)obj;
		return (key == null ? other.key == null : key.equals(other.key));
	}

	@Override
	public int hashCode() {
		int result = 17;
		result = 37 * result + (key == null ? 0 : key.hashCode());
		return result;
	}

	public int compareTo(ResultKey other) {
		if ( key != null && other.key != null ) {
			int result = key.compareTo(other.key);
			if ( result != 0 ) return result;
		}
		return -1;
	}
	
	public String toString() {
		return "[key="+key+",description="+description+"]";
	}
	
}