package gov.va.med.mhv.sm.model.report;

import gov.va.med.mhv.sm.enumeration.ReportingPeriodEnum;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.util.PeriodsHelper;

import java.io.Serializable;
import java.util.Date;

public class ReportResults implements Serializable {
	
	protected boolean emptyResults = true;
	protected Date runDate = new Date();
	protected ReportingPeriodEnum period = null;
	
	public ReportResults() {
	}

	public Date getRunDate() {
		return runDate;
	}

	public void setRunDate(Date runDate) {
		this.runDate = runDate;
	}

	public ReportingPeriodEnum getPeriod() {
		return period;
	}

	public void setPeriod(ReportingPeriodEnum period) {
		this.period = period;
	}
	
	public String getFormattedRunDate() {
		return DateUtils.getEnglishDateTime(runDate);
	}
	
	public boolean isEmptyResults() {
		return emptyResults;
	}

	public void setEmptyResults(boolean emptyResults) {
		this.emptyResults = emptyResults;
	}
}
