package gov.va.med.mhv.sm.model.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ListsResultsDetails implements Serializable {
	private static final long serialVersionUID = -5715848199450586843L;
	private String id;
	private String description;
	
	private List<SortRecord> data = new ArrayList<SortRecord>();
	private List<String> fieldslist;
	private Map<String, Integer> fieldIndex = new HashMap<String, Integer>();

	public ListsResultsDetails(String id, String description, List<String> fields) {
		this.id = id;
		this.description = description;
		setFieldsList(fields);
	}

	public int getNextRow() {
		String arr[] = new String[fieldslist.size()];
		SortRecord sr = new SortRecord(arr);
		data.add(sr);
		return data.indexOf(sr);
	}

	public void setValue(String key, Integer row, String value) {
		SortRecord arr = data.get(row);
		arr.setValue(fieldIndex.get(key).intValue(), value);
	}
	
	public String getValue(Integer field, Integer row) {
		return data.get(row).getValue(field.intValue());
	}
	
	public String getValue(int field, int row) {
		return data.get(row).getValue(field);
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getSize() {
		return data.size();
	}
	
	public String getId() {
		return id;
	}

	public void setFieldsList(List<String> newFields) {
		int count = 0;
		for(String p: newFields) {
			fieldIndex.put(p, new Integer(count++));
		}
		this.fieldslist=newFields;
	}

	public List<String> getFieldsList() {
		return fieldslist;
	}
	
	public int getFieldPosition(String field) {
		if( fieldIndex.containsKey(field)) {
			return ((Integer)fieldIndex.get(field)).intValue();
		}
		else {
			return -1;
		}
	}
	
	public void sortData() {
		//Use the field list
		for( SortRecord r: data ) {
			r.setFieldIndex(fieldIndex);
			r.setFieldslist(fieldslist);
		}
		Collections.sort(data, LISTS_RESULTS_DETAILS_SORTER);
	}
	
	public static final Comparator<SortRecord> LISTS_RESULTS_DETAILS_SORTER = new Comparator<SortRecord>() {
		public int compare(SortRecord a, SortRecord b) {
			StringBuffer a1 = new StringBuffer();
			StringBuffer b1 = new StringBuffer();
			if( a.getKey() == null ) {
				for( String f:a.getFieldslist()) {
					int pos = ((Integer)a.getFieldIndex().get(f)).intValue();
					a1.append(a.getValue(pos));
				}
			}
			
			if( b.getKey() == null ) {
				for( String f:a.getFieldslist()) {
					int pos = ((Integer)b.getFieldIndex().get(f)).intValue();
					b1.append(b.getValue(pos));
				}
			}
			
			if(a1 == null || b1 == null) return 0;
			return a1.toString().compareToIgnoreCase(b1.toString());
		}
	};
	
}

class SortRecord {
	private String key;
	private String values[];
	private List<String> fieldslist;
	private Map<String, Integer> fieldIndex = new HashMap<String, Integer>();
	
	public SortRecord(String[] v) {
		this.values=v;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getValue(int col) {
		return values[col];
	}
	public void setValue(int col, String value) {
		this.values[col] = value;
	}
	public List<String> getFieldslist() {
		return fieldslist;
	}
	public void setFieldslist(List<String> fieldslist) {
		this.fieldslist = fieldslist;
	}
	public Map<String, Integer> getFieldIndex() {
		return fieldIndex;
	}
	public void setFieldIndex(Map<String, Integer> fieldIndex) {
		this.fieldIndex = fieldIndex;
	}
}
