package gov.va.med.mhv.sm.model.report;

import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.ListsSubCategoryEnum;
import gov.va.med.mhv.sm.util.DateUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListsResults extends ReportResults {
	private static final Log log = LogFactory.getLog(ListsResults.class);
	
	private static final long serialVersionUID = 1L;
	private Date end;
	private String filterTitle = "";
	private String visnTitle = "";
	private String facilityTitle = "";

	private List<ListsResultsDetails> results = new ArrayList<ListsResultsDetails>();

	private Map<ListsSubCategoryEnum, ListsResultsDetails> resultIndex = new HashMap<ListsSubCategoryEnum, ListsResultsDetails>();

	private List<ListsSubCategoryEnum> subCategories;
	
	public ListsResults() {
	}

	public Date getEnd() {
		return end;
	}

	public String getEndDateFormatted() {
		return DateUtils.getEnglishDate(end);
	}
	
	public void setEnd(Date end) {
		this.end = end;
	}

	public void addRow(ListsSubCategoryEnum subCat, List<ResultKey>cols) {
		if( resultIndex.containsKey(subCat)) {
			int row = ((ListsResultsDetails)resultIndex.get(subCat)).getNextRow();
			for( ResultKey f: cols) {
				if(log.isInfoEnabled()) {
					log.info("Processing " + f.getKey() + " : " + f.getDescription() + "  "+f.getKey()+"["+row+"]='"+f.getDescription()+"'");
				}
				((ListsResultsDetails)resultIndex.get(subCat)).setValue(f.getKey(), row, f.getDescription());
			}
		}
	}	
	
	public void sortListsResultsDetails() {
		for( ListsResultsDetails l: results ) {
			l.sortData();
		}
	}
	
	public ListsResultsDetails getListResultsDetailsForSubcategory(ListsSubCategoryEnum subcat) {
		return resultIndex.get(subcat);
	}
	
	public void addListsResultsDetails(ListsSubCategoryEnum subCat, String uniqueId, String description, List<String> fields) {
		ListsResultsDetails details = new ListsResultsDetails(uniqueId, description, fields);
		resultIndex.put(subCat, details);
		results.add(details);
	}
	
	public void setSubCategories(List<ListsSubCategoryEnum> subCategories) {
		this.subCategories = subCategories;
	}
	
	public List<ListsSubCategoryEnum> getSubCategories() {
		return subCategories;
	}
	
	@SuppressWarnings("unchecked")
	public Collection<ListsSubCategoryEnum> getSubCategoriesSorted() {
		List<ListsSubCategoryEnum> list = new ArrayList<ListsSubCategoryEnum>();
		for(ListsSubCategoryEnum cat: subCategories) {
			list.add(cat);
		}
		Collections.sort(list, ListsSubCategoryEnum.LISTS_SUBCATEGORY_SORTER);
		return (Collection)list;
	}
	
	public String getFilterTitle() {
		return filterTitle;
	}

	public void setFilterTitle(String filterTitle) {
		this.filterTitle = filterTitle;
	}

	public String getFacilityTitle() {
		return facilityTitle;
	}

	public void setFacilityTitle(String facilityTitle) {
		this.facilityTitle = facilityTitle;
	}

	public String getVisnTitle() {
		return visnTitle;
	}

	public void setVisnTitle(String visnTitle) {
		this.visnTitle = visnTitle;
	}

}
