package gov.va.med.mhv.sm.model.report;

import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.CountsSubCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ReportingCountsTypeEnum;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.util.PeriodsHelper;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountsResults extends ReportResults {
	private static final long serialVersionUID = -3854183779508059156L;
	private static final Log log = LogFactory.getLog(CountsResults.class);

	private Date start;
	private Date end;
	private String filterTitle = "";
	private Date lastRefreshDate;

	private List<CountsResultsDetails> results = new ArrayList<CountsResultsDetails>();

	// An index into the list of (Team/VISN/Facility)
	private Map<String, CountsResultsDetails> resultIndex = new HashMap<String, CountsResultsDetails>();
	private Map<CountsSubCategoryEnum, Integer> subCategoryIndex = new HashMap<CountsSubCategoryEnum, Integer>();
	private Map<String, Integer> periodIndex = new HashMap<String, Integer>();

	private List<String> periods;
	private Collection<CountsSubCategoryEnum> subCategories;

	public CountsResults() {
	}

	public Date getEnd() {
		return end;
	}

	public String getEndDateFormatted() {
		return DateUtils.getEnglishDate(end);
	}

	public void setEnd(Date end) {
		this.end = end;
	}

	public Date getStart() {
		return start;
	}

	public String getStartDateFormatted() {
		return DateUtils.getEnglishDate(start);
	}

	public void setStart(Date start) {
		this.start = start;
	}

	public void setValue(String uniqueId, CountsSubCategoryEnum field, String period, String value) {
//		System.out.println("-----------------");
//		System.out.println("uniqueId="+uniqueId+", period="+period+",subcategory="+field+",value="+value);
//		System.out.println("periodIndex="+periodIndex.get(period));
//		System.out.println("subCategoryIndex="+subCategoryIndex.get(field));
//		System.out.println("ResultContainer found?" + resultIndex.get(uniqueId)!=null);
//		System.out.println("-----------------");
		if( resultIndex.containsKey(uniqueId)) {
			((CountsResultsDetails)resultIndex.get(uniqueId)).setValue(periodIndex.get(period), subCategoryIndex.get(field), value);
			super.setEmptyResults(false);
		}
	}

	public void setValueForVisnName(String uniqueId, String visnName) {
		if( resultIndex.containsKey(uniqueId)) {
			((CountsResultsDetails)resultIndex.get(uniqueId)).setVisnName(visnName);
		}
	}

	public void setValueForFacilityName(String uniqueId, String facilityName) {
		if( resultIndex.containsKey(uniqueId)) {
			((CountsResultsDetails)resultIndex.get(uniqueId)).setFacilityName(facilityName);
		}
	}

	public List<CountsResultsDetails> getCountsResultsDetails() {
		return results;
	}

	public void addCountsResultsDetails(String uniqueId, String description, String visnName, String facilityName) {
		CountsResultsDetails details = new CountsResultsDetails(uniqueId, description, periodIndex.size(), subCategoryIndex.size());
		details.setFacilityName(facilityName);
		details.setVisnName(visnName);
		resultIndex.put(uniqueId, details);
		results.add(details);
	}

	public void setSubCategories(Collection<CountsSubCategoryEnum> subCategories) {
		int count = 0;
		for(CountsSubCategoryEnum cat: subCategories) {
			subCategoryIndex.put(cat, new Integer(count++));
		}
		this.subCategories = subCategories;
	}

	public void setPeriods(List<String> periods) {
		int count = 0;
		for(String p: periods) {
			periodIndex.put(p, new Integer(count++));
		}
		this.periods=periods;
	}

	public List<String> getPeriods() {
		return periods;
	}

	/**
	 * Formats the periods based on the day/week/month/quarter/fiscal year
	 *
	 * @return
	 */
	public List<String> getFormattedPeriods() {
		List<String> fPeriods = new ArrayList<String>();
		String format = "";

		switch(period) {
			case DAY:
			case WEEK:format="MM/dd/yyyy"; break;
			case MONTH:format="MMM yyyy"; break;
			case QUARTER:format="MM/yyyy"; break;
			case FISCAL_YEAR:format="yyyy"; break;
		}

		for(String p:periods) {
			Date d;
			try {
				d = DateUtils.parseDateNoLeniency(p,DateUtils.ENGLISH_DATE_FORMAT);
				String label = DateUtils.formatDate(d,format);
				switch(period) {
					case QUARTER:label="Quarter " + PeriodsHelper.getQuarterYearForMonthYear(label.substring(0,label.indexOf('/')),label.substring(label.indexOf('/')+1));
						break;
					case FISCAL_YEAR:label="FY " + label; break;
				}
				fPeriods.add(label);
			} catch (ParseException e) {
				log.error("Unable to parse " + p, e);
			}
		}
		return fPeriods;
	}

	public Collection<CountsSubCategoryEnum> getSubCategories() {
		return subCategories;
	}

	@SuppressWarnings("unchecked")
	public Collection<CountsSubCategoryEnum> getSubCategoriesSorted() {
		List<CountsSubCategoryEnum> list = new ArrayList<CountsSubCategoryEnum>();
		for(CountsSubCategoryEnum cat: subCategories) {
			list.add(cat);
		}
		Collections.sort(list, CountsSubCategoryEnum.COUNTS_SUBCATEGORY_SORTER);
		return (Collection)list;
	}

	public List<String> getSubCategoriesAsStringsForType(ReportingCountsTypeEnum type) {
		List<String> res = new ArrayList<String>();
		for(CountsSubCategoryEnum c: getSubCategoriesSorted()) {
			if( (type.equals(ReportingCountsTypeEnum.COUNTS) && c.isCounts()) ||
				(type.equals(ReportingCountsTypeEnum.TRENDS) && c.isTrends()) ||
				(type.equals(ReportingCountsTypeEnum.DASHBOARD) && c.isDashboard()) ) {
				res.add(c.getDescription());
			}
		}
		return res;
	}

	public int getPeriodPosition(String period) {
		if( periodIndex.containsKey(period)) {
			return ((Integer)periodIndex.get(period)).intValue();
		}
		else {
			return -1;
		}
	}

	public List<String> getCountsResultsDetailsNames() {
		List<String> names = new ArrayList<String>();
		for(CountsResultsDetails d: results ) {
			names.add(d.getDescription());
		}
		return names;
	}

	public Integer getSubCategoryPosition(int subCategoryId) {
		return subCategoryIndex.get(CountsSubCategoryEnum.valueOf(subCategoryId));
	}

	public String getFilterTitle() {
		return filterTitle;
	}

	public void setFilterTitle(String filterTitle) {
		this.filterTitle = filterTitle;
	}

	public Date getLastRefreshDate() {
		return lastRefreshDate;
	}

	public String getFormattedLastRefreshDate() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(lastRefreshDate);
		cal.add(Calendar.DATE,-1);
		return DateUtils.getEnglishDate(cal.getTime());
	}

	public void setLastRefreshDate(Date lastRefreshDate) {
		this.lastRefreshDate = lastRefreshDate;
	}

}
