package gov.va.med.mhv.sm.model;

import java.io.Serializable;
import java.util.List;

import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;

/**
 * 
 * @author DNS   mccarw
 *
 *  This is the relationship between a TriageGroup and
 *  the clinic/teams.  This is how patients are identified
 *  to "belong" to certain TriageGroups.  
 *
 */


public class TriageRelation extends BaseModel implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4774918485317242413L;
	private RelationTypeEnum relationType;
	private String name;
	private String stationNumber;
	private String vistaIen;
	private TriageGroup triageGroup;
	
	private List<Patient> patients;
	
	public RelationTypeEnum getRelationType() {
		return relationType;
	}
	public void setRelationType(RelationTypeEnum relationType) {
		this.relationType = relationType;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getStationNumber() {
		return stationNumber;
	}
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	public String getVistaIen() {
		return vistaIen;
	}
	public void setVistaIen(String vistaIen) {
		this.vistaIen = vistaIen;
	}
	public TriageGroup getTriageGroup() {
		return triageGroup;
	}
	public void setTriageGroup(TriageGroup triageGroup) {
		this.triageGroup = triageGroup;
	}
	public List<Patient> getPatients() {
		return patients;
	}
	public void setPatients(List<Patient> patients) {
		this.patients = patients;
	}
	
	public String toString(){
		return getId() + "^" + getName();
	}
	
	
}
