package gov.va.med.mhv.sm.enumeration;

public enum UserStatusEnum {

	OPT_OUT (0L, "opt-out"),
	OPT_IN (1L, "opt-in"),
	BLOCKED(2L, "Patient Blocked to SM"),
	/**
	 * Represents the fact that a user has not chosen to opt-in or opt-out yet.
     * Typically this value would be used for new users only!
     **/
	// Allowing null or 0 would have made more sense for NO_OPTION_CHOSEN,
    // but taking the simplest approach with least impact,
	// as both other options require a database change
	NO_OPTION_CHOSEN(3L, "no-option-chosen"),
	MANUALLY_ASSOCIATED_PATIENT(4L,"Manually Associated Patient Default Status"),
	BLOCKED_FROM_TRIAGE_GROUP(5L,"Patient Blocked from Triage Group(s)"),
	BLOCKED_FROM_FACILITY(6L,"Patient Blocked from Facility"),
	UNBLOCKED_FROM_FACILITY(7L,"Patient Un-Blocked from Facility");

	private Long id;
	private String description;

	private UserStatusEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	public static UserStatusEnum valueOf(Long value){
		for(UserStatusEnum f : UserStatusEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("invalid status");
	}
}