package gov.va.med.mhv.sm.enumeration;

public enum SortOrderEnum {

	/* the numeric values mean nothing except for
	 * possibly using them as parameters in the web tier
	 */
	ASC(1),
	DESC(2);
	
	private int id;
	
	private SortOrderEnum(int id){
		this.id = id;
	}
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public static SortOrderEnum valueOf(int value){
		for(SortOrderEnum f : SortOrderEnum.values()){
			if(f.getId() == value)
				return f;
		}
		/* none found; return default */
		return ASC;
	}
	
	
}
