/**
 * 
 */
package gov.va.med.mhv.sm.enumeration;


public enum ReAssignMessageActionEnum {

	MESSAGE_RECEIVED(1L, "Message received from Patient and not yet assigned"),
	SYSTEM_AUTO_ASSIGN (2L, "System auto-assigned message"),
	REASSIGN_WITHIN_TG(3L, "Message reassigned within Triage Group"),
	REASSIGN_ANOTHER_TG_WITH_IN_FACILITY(4L, "Message reassigned to another TG within Facility"),
	REASSIGN_ANOTHER_STAFF_WITH_IN_FACILITY(5L, "Message reassigned to another TG/ Staff within Facility"),
	MESSAGE_TRANSFERRED_TG_OUTSIDE_FACILITY (6L, "Message reassigned to another TG outside  Facility"),
	MESSAGE_TRANSFERRED_STAFF_OUTSIDE_FACILITY (7L, "Message reassigned  to another TG/ Staff outside Facility"),
	MESSAGE_COMPLETION(8L, "Message Completion"),
	MESSAGE_ESCALATION(9L, "Message Escalation"),
	MESSAGE_REASSIGN_PENDING_PATIENT_NOT_IN_TG (10L, "Message reassignment pending (patient not yet associated to receiving Triage Group)"),
	MESSAGE_REASSIGN_PENDING_PATIENT_NOT_IN_FACILITY (11L, "Message reassignment pending (patient not yet loaded into Vista in the receiving facility)"),
	PROVIDER_ASSOCIATE_PATIENT_TO_GROUP(12L,"Patient automatically added to the Triage Group"),
	EMAIL_NOTIFICATION_SENT_TO_ADMINS(13L,"Email notification sent to add Patient to Facility");
	
	private Long id;
	private String name;
	
	private ReAssignMessageActionEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static ReAssignMessageActionEnum valueOf(Long value){
		for(ReAssignMessageActionEnum f : ReAssignMessageActionEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no enum found");
	}
	
	
	
}
