package gov.va.med.mhv.sm.enumeration;

public enum ParticipantTypeEnum {

	PATIENT(1L, "Patient"),
	CLINICIAN (2L, "Clinician"),
	TRIAGE_GROUP (3L, "Triage Group"),
	DISTRIBUTION_GROUP (4L, "Distribution Group");
	
	private Long id;
	private String description;
	
	private ParticipantTypeEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static ParticipantTypeEnum valueOf(Long value){
		for(ParticipantTypeEnum f : ParticipantTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no relation type found");
	}
	
}
