package gov.va.med.mhv.sm.enumeration;

import java.util.Arrays;
import java.util.List;

public enum MessageFilterEnum {

	ALL(0L, "All"),
	ASSIGNED_TO_ME(1L, "Assigned to me"),
	UNASSIGNED(2L,"Unassigned");
	
	private Long id;
	private String name;
	
	private MessageFilterEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static MessageFilterEnum valueOf(Long value){
		for(MessageFilterEnum f : MessageFilterEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; return default */
		return MessageFilterEnum.ALL;
	}
	
	public static List<MessageFilterEnum> toList(){
		return Arrays.asList(MessageFilterEnum.values());
	}
}
