package gov.va.med.mhv.sm.enumeration;

import java.util.Arrays;
import java.util.List;

public enum MessageCategoryTypeEnum {
	OTHER (0L, "General"),
	APPOINTMENTS (10L, "Appointment"),
	MEDICATIONS (30L, "Medication"),
	TEST_RESULTS (20L, "Test"),
	EDUCATION(40L,"Education");
	
	private Long id;
	private String name;
	
	private MessageCategoryTypeEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static MessageCategoryTypeEnum valueOf(Long value){
		for(MessageCategoryTypeEnum f : MessageCategoryTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		return MessageCategoryTypeEnum.OTHER;  //Default MessageCategoryEnum
		/* none found; throw error */
		//throw new RuntimeException("no enum found");
	}
	
	public static List<MessageCategoryTypeEnum> toList(){
		return Arrays.asList(MessageCategoryTypeEnum.values());
	}
}
