package gov.va.med.mhv.sm.enumeration;


public enum ListsFieldEnum {

	LAST_NAME (0,"Last Name"),
	FIRST_NAME (1,"First Name"),
	USER_TYPE (2,"User Type"),
	NSSN (3,"NSSN"),
	DOB_MONTH_DAY (4,"DoB: Month/Day"),
	STATION_NUMBER (5,"Station Number"),
	TEAM_NAME (6,"Team Name"),
	SIGNATURE (7,"Signature"),
	LAST_MESSAGE_ID (8,"Message Id"),
	CREATED_DATE (9,"Message Date"),
	SM_CLINIC_NAME (10,"Associated SM Workload Credit Clinic"),
	CPRS_TITLE_NAME (11,"Associated CPRS Note Title");
	
	
	private int id;
	private String name;
	
	private ListsFieldEnum(int id, String name){
		this.id = id;
		this.name = name;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static ListsFieldEnum valueOf(int value){
		for(ListsFieldEnum f : ListsFieldEnum.values()){
			if(f.getId() == value)
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no ListsFieldEnum type found for " + value);
	}
	
}
