package gov.va.med.mhv.sm.enumeration;


public enum EmailNotificationTypeEnum {

	NEW_MESSAGE_EMAIL_NOTIFICATION(1L,"New Email Notification"),
	REASSIGN_MESSAGE_EMAIL_NOTIFICATION(2L, "ReAssign Message Notification"),
	FACILITY_ADMIN_EMAIL_NOTIFICATION(3L,"Facility Admin Notification");
	
	private Long id;
	private String name;
	
	private EmailNotificationTypeEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static EmailNotificationTypeEnum valueOf(Long value){
		for(EmailNotificationTypeEnum f : EmailNotificationTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no EmailNotificationTypeEnum found");		
	}
	
	
}
