package gov.va.med.mhv.sm.enumeration;

import java.util.Arrays;
import java.util.List;

public enum EmailNotificationEnum {

	NONE(0L,"None"),
	EACH_MESSAGE(1L, "Each message"),
	ONE_DAILY(2L, "Once daily"),
	ON_ASSIGNEMNT(3L, "On assignment to me");
	
	private Long id;
	private String name;
	
	private EmailNotificationEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static EmailNotificationEnum valueOf(Long value){
		for(EmailNotificationEnum f : EmailNotificationEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; return default */
		return EmailNotificationEnum.NONE;
	}
	
	public static List<MessageFilterEnum> toList(){
		return Arrays.asList(MessageFilterEnum.values());
	}
	
}
