package gov.va.med.mhv.sm.enumeration;

import java.util.Comparator;

public enum CountsSubCategoryEnum {
	
	ACTION_PENDING_PATIENTS (0, "Patients - Action Pending",true,true,false, CountsSubCategoryTypeEnum.SUM,"Patients have not yet opted in to use SM, and have not opted out.", true),
	ASSOCIATED_PATIENTS (2, "Patients - Associated",true,true,false, CountsSubCategoryTypeEnum.SUM,"Patients are associated with a Healthcare Team.", false),
	BLOCKED_PATIENTS (3, "Patients - Blocked",true,true,false, CountsSubCategoryTypeEnum.SUM,"A blocked patient has been prevented from using SM based on SM policy. This is performed by a SM Administrator.", true),
	CPRS_TIU_PROGRESS_NOTE (4, "Team - CPRS TIU Progress Note",true,true,true, CountsSubCategoryTypeEnum.SUM,"Count/percentage  of instances in which message contents are copied to a TIU Progress Note in CPRS.", false),
	FIRST_MESSAGE_RESOLUTION_RATE (5, "Team - First Message Resolution Rate",true,true,true, CountsSubCategoryTypeEnum.SUM,"Count/percentage of completed messages resolved/completed without being assigned to another SM Healthcare Team member.", false),
	INBOUND_MESSAGE_VOLUME (7, "Message - Volume Inbound",true,true,false, CountsSubCategoryTypeEnum.SUM,"Displays graphical view of inbound message volume trends over time.", false),
	MESSAGE_COMPLETED_BY_PROVIDER (8, "Team - Message Completed By Provider",true,true,false, CountsSubCategoryTypeEnum.SUM,"Count/percentage  of completed messages during a given time period by user type.", false),
	MESSAGE_COMPLETED_BY_TRIAGESTAFF (9, "Team - Message Completed By Triage Staff",true,true,false, CountsSubCategoryTypeEnum.SUM,"Count/percentage  of completed messages during a given time period by user type.", false),
	MESSAGE_COMPLETED_BY_TEAMMEMBER (10, "Team - Message Completed By Clinical Team Member",true,true,false, CountsSubCategoryTypeEnum.SUM,"Count/percentage  of completed messages during a given time period by user type.", false),	
	MESSAGE_COMPLETION_TIMES_AVG (11, "Message - Average Completion Times",true,true,false, CountsSubCategoryTypeEnum.AVERAGE,"Displays mean days for message completion within a selected date range.", false),
	MESSAGE_COMPLETION_TIMES_MAX (12, "Message - Maximum Completion Times",true,true,false, CountsSubCategoryTypeEnum.MAXIMUM,"Displays maximum days for message completion within a selected date range.", false),
	MESSAGE_COMPLETION_TIMES_MIN (13, "Message - Minimum Completion Times",true,true,false, CountsSubCategoryTypeEnum.MINIMUM,"Displays minimum days for message completion within a selected date range.", false),
	MESSAGE_COMPLETION_VOLUME (14, "Message - Volume Completion",true,true,true, CountsSubCategoryTypeEnum.SUM,"Count/percent of inbound messages completed for a selected date range.", false),
	MESSAGE_COMPLETION_WITHIN_TARGET (15, "Message - Completion within Target",true,true,true,CountsSubCategoryTypeEnum.SUM,"Count/percentage of messages that are completed within 3 business days.", false),
	MESSAGE_ESCALATION (16, "Message - Escalated",true,true,true,CountsSubCategoryTypeEnum.SUM,"A patient message is escalated when it has not been resolved/completed within 3 business days. There are acceptable reasons for this. The goal is to ensure no message is ignored.", false),
	MESSAGE_STATUS_IN_PROGRESS (18, "Team - Message In Process",true,true,false,CountsSubCategoryTypeEnum.SUM,"Displays count of messages by message status in 'process' for a selected date range.", false),
	MESSAGE_STATUS_READ (19, "Team - Message Read",true,true,false,CountsSubCategoryTypeEnum.SUM,"Displays count of messages by message status 'read' for a selected date range.", false),
	MESSAGE_STATUS_UNREAD (20, "Team - Message Unread",true,true,false,CountsSubCategoryTypeEnum.SUM,"Displays count of messages by message status 'unread' for a selected date range.", false),
	MESSAGE_THREADS (21, "Message - Threads",true,true,false,CountsSubCategoryTypeEnum.SUM,"An initial message with all subsequent replies.", false),
	MESSAGE_TYPES_APPOINTMENT (22, "Message - Subject: Appointment",true,true,true,CountsSubCategoryTypeEnum.SUM,"Percentages of each message type, based on use of message sub-category 'Appointment'.", false),
	MESSAGE_TYPES_GENERAL (23, "Message - Subject: General (default)",true,true,true,CountsSubCategoryTypeEnum.SUM,"Percentages of each message type, based on use of message sub-category 'General'.", false),
	MESSAGE_TYPES_MEDICATION (24, "Message - Subject: Medication",true,true,true,CountsSubCategoryTypeEnum.SUM,"Percentages of each message type, based on use of message sub-category 'Medication'.", false),
	MESSAGE_TYPES_TEST (25, "Message - Subject: Test",true,true,true,CountsSubCategoryTypeEnum.SUM,"Percentages of each message type, based on use of message sub-category 'Test'.", false),
	OPTED_IN_PATIENTS (26, "Patients - Opted In",true,true,false,CountsSubCategoryTypeEnum.SUM,"Patients opt in when they agree to the terms of SM use. This is required to send or receive a message.", true),
	OPTED_OUT_PATIENTS (27, "Patients - Opted Out",true,true,false,CountsSubCategoryTypeEnum.SUM,"Patients opt out when they decline the terms of SM use, and can no longer send or receive a message.", true),
	OUTBOUND_MESSAGE_VOLUME (28, "Message - Volume Outbound",true,true,false,CountsSubCategoryTypeEnum.SUM,"The outbound volume represents Healthcare Team responses to prior inbound messages and new messages sent by Health Care Team members.", false),
	TOTAL_MESSAGE_VOLUME (29, "Message - Volume Total",true,true,false,CountsSubCategoryTypeEnum.SUM,"Total message Volume represents the complete volume of all messages, including messages from patients and from Healthcare Team members. ", false),
	UNIQUE_PATIENT_SENDERS (30, "Patients - Unique Senders",true,true,false,CountsSubCategoryTypeEnum.SUM,"The number of unique patients sending a message during the specified time range.",true),
	UNIQUE_TEAM_MEMBERS_SENDERS (31, "Team - Unique Member Senders",true,true,false,CountsSubCategoryTypeEnum.SUM,"The number of unique healthcare team members sending a message during the specified time range.",true),
	MESSAGE_TYPES_EDUCATION (32, "Message - Subject: Education",true,true,true,CountsSubCategoryTypeEnum.SUM,"Percentages of each message type, based on use of message sub-category 'Education'.", false);
	
	private int id;
	private String description;
	private boolean counts = false, trends = false, dashboard = false;
	private CountsSubCategoryTypeEnum type;
	private String longDescription;
	private boolean liveSearch;
	
	private CountsSubCategoryEnum(int id, String description, boolean counts, boolean trends, boolean dashboard, CountsSubCategoryTypeEnum type, String longDescription, boolean liveSearch ){
		this.id = id;
		this.description = description;
		this.counts=counts;
		this.trends=trends;
		this.dashboard=dashboard;
		this.type=type;
		this.longDescription = longDescription;
		this.liveSearch = liveSearch;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public boolean isDashboard() {
		return dashboard;
	}
	public void setDashboard(boolean dashboard) {
		this.dashboard = dashboard;
	}
	public boolean isCounts() {
		return counts;
	}
	public void setCounts(boolean counts) {
		this.counts = counts;
	}
	public boolean isTrends() {
		return trends;
	}
	public void setTrends(boolean trends) {
		this.trends = trends;
	}
	public boolean isType(CountsSubCategoryTypeEnum type) {
		return this.type.equals(type);
	}
	public CountsSubCategoryTypeEnum getType() {
		return this.type;
	}
	public String getLongDescription() {
		return longDescription;
	}
	public void setLongDescription(String longDescription) {
		this.longDescription = longDescription;
	}
	public boolean isLiveSearch() {
		return liveSearch;
	}
	public void setLiveSearch(boolean liveSearch) {
		this.liveSearch = liveSearch;
	}
	
	public static CountsSubCategoryEnum valueOf(int value){
		for(CountsSubCategoryEnum f : CountsSubCategoryEnum.values()){
			if(f.getId() == value)
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no CountsSubCategoryEnum type found for " + value);
	}
	
	public static final Comparator<CountsSubCategoryEnum> COUNTS_SUBCATEGORY_SORTER = new Comparator<CountsSubCategoryEnum>() {
		public int compare(CountsSubCategoryEnum a, CountsSubCategoryEnum b) {
			String a1 = a.getDescription();
			String b1 = b.getDescription();
			if(a1 == null || b1 == null) return 0;
			return a1.compareToIgnoreCase(b1);
		}
	};
	
}
