package gov.va.med.mhv.sm.enumeration;

import java.util.Arrays;
import java.util.List;

/**
 * 
 * @author DNS   mccarw
 *
 * Clinicians set a status on messages for simple
 * communication between themselves.
 *
 */
public enum ClinicianStatusEnum{

	/**
	 * CAUTION:  currently the sort order for the "STATUS"
	 *  in the INBOX is based upon the ID's represented here.
	 */
	INCOMPLETE (0L, "", "Incomplete"),
	INPROCESS (10L, "In process", "In process"),
	COMPLETE (20L, "Complete", "Complete");
	
	
	private Long id;
	private String status;
	
	/* alternative form of status.  Used when  a 
	 * non-blank value is required for INCOMPLETE
	 */
	private String statusAlt;
	
	private ClinicianStatusEnum(Long id, String status, String statusAlt){
		this.id = id;
		this.status = status;
		this.statusAlt = statusAlt;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatusAlt() {
		return statusAlt;
	}
	public void setStatusAlt(String statusAlt) {
		this.statusAlt = statusAlt;
	}
	
	public static ClinicianStatusEnum valueOf(Long value){
		for(ClinicianStatusEnum f : ClinicianStatusEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no clinician status type found");
	}

	public static List<ClinicianStatusEnum> toList(){
		return Arrays.asList(ClinicianStatusEnum.values());
	}
	
}
