package gov.va.med.mhv.sm.enumeration;

import java.io.Serializable;

public enum ClinicalUserTypeEnum implements Serializable {

	PROVIDER (1L, "Provider"),
	CLINICAL_TEAM_MEMBER (2L, "Clinical Team Member"),
	TRIAGE_STAFF(3L, "Triage Staff");
	
	
	private Long id;
	private String description;
	
	private ClinicalUserTypeEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static ClinicalUserTypeEnum valueOf(Long value){
		for(ClinicalUserTypeEnum f : ClinicalUserTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no clinical user type found");
	}
	
}
