package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.hibernate.LockMode;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.TriageRelationDao;
import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;


public class TriageRelationDaoImpl extends BaseEntityDaoHibernate<TriageRelation, Long>
	implements TriageRelationDao {

	@SuppressWarnings("unchecked")
	public List<TriageRelation> getTriageGroupRelationsForPatient(
			Patient patient) {
		String[] paramNames = new String[] { "patientId" };
		Object[] paramValues = new Object[] { patient.getId()};

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PATIENT_TRIAGE_GROUP_RELATIONS, paramNames, paramValues );
	}

	public void fleshTriageGroup(TriageRelation tr){
		getSession().lock(tr, LockMode.NONE);
		getHibernateTemplate().initialize(tr.getTriageGroup());
	}

	@SuppressWarnings("unchecked")
	public List<TriageRelation> getTriageGroupRelationsForPatientAll(
			Patient patient) {
		String[] paramNames = new String[] { "patientId" };
		Object[] paramValues = new Object[] { patient.getId()};

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PATIENT_TRIAGE_GROUP_RELATIONS_ALL, paramNames, paramValues );
	}


	@SuppressWarnings("unchecked")
	public List<TriageRelation> getTriageGroupRelationsForPatientStation(
			Patient patient, String stationNo) {
		String[] paramNames = new String[] { "patientId", "stationNo" };
		Object[] paramValues = new Object[] { patient.getId(), stationNo };

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PATIENT_TRIAGE_GROUP_RELATIONS_BY_STATION, paramNames, paramValues );
	}

	@SuppressWarnings("unchecked")
	public List<TriageRelation> getTriageGroupRelationsForPatientStationAll(
			Patient patient, String stationNo) {
		String[] paramNames = new String[] { "patientId", "stationNo" };
		Object[] paramValues = new Object[] { patient.getId(), stationNo };

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PATIENT_TRIAGE_GROUP_RELATIONS_BY_STATION_ALL, paramNames, paramValues );
	}


	@SuppressWarnings("unchecked")
	public List<TriageRelation> find(String ien, String stationNo, RelationTypeEnum relationType) {
		String[] paramNames = new String[] { "ien", "stationNo", "relationType" };
		Object[] paramValues = new Object[] { ien, stationNo, relationType };

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_RELATIONS_FOR_IEN, paramNames, paramValues );
	}



	@SuppressWarnings("unchecked")
	public List getRelationId(Long triageGroupId,String patientId) {
		String[] paramNames = new String[] {"triageGroupId", "patientId" };
		Object[] paramValues = new Object[] {triageGroupId, patientId};
		return getHibernateTemplate().findByNamedQueryAndNamedParam("QryGetTriageRelationId", paramNames, paramValues);
	}


	public List<TriageRelation> getTriageRelationsForTriageGroup(Long triageGroupId){
		
			String[] paramNames = new String[] { "triageGroupId" };
			Object[] paramValues = new Object[] { triageGroupId};

			return getHibernateTemplate().findByNamedQueryAndNamedParam(
					QRY_TRIAGE_RELATIONs_For_TRIAGEGROUP, paramNames, paramValues );
	}

}
