package gov.va.med.mhv.sm.dao.hibernate;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SMClinicsCPRSTitle;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.TriageGroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

import org.hibernate.LockMode;
import org.springframework.dao.DataIntegrityViolationException;

public class TriageGroupDaoImpl extends BaseEntityDaoHibernate<TriageGroup, Long>
	implements TriageGroupDao{


	@SuppressWarnings("unchecked")
	public void getPatientsForTriageGroup(TriageGroup t){

		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { t.getId()};

		List<Patient> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUP_PATIENTS, paramNames, paramValues );

		t.setPatients(l);
	}


	public void getCliniciansForTriageGroup(TriageGroup t){

		try {
			getSession().lock(t, LockMode.NONE);
			getHibernateTemplate().initialize(t.getClinicians());
		} catch (Exception e) {
			/* no op */
		}
	}

	@SuppressWarnings("unchecked")
	public TriageGroup getSMClinicsForTriageGroup(Long triageGroupId){

		TriageGroup triageGroup = findById(triageGroupId);

		if (triageGroup == null) {
			/* no triage group matched */
			return null;
		}

		try{
			getSession().lock(triageGroup,LockMode.NONE);
			getHibernateTemplate().initialize(triageGroup.getSmClinics());

		}catch(Exception eeee){

		}

		return triageGroup;
	}


	@SuppressWarnings("unchecked")
	public Collection<TriageGroup> getTriageGroupsForPatient(Patient p){

		String[] paramNames = new String[] { "patientId" };
		Object[] paramValues = new Object[] { p.getId()};

		Collection<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUPS_FOR_PATIENTS, paramNames, paramValues );

		return l;
	}

	@SuppressWarnings("unchecked")
	public Collection<TriageGroup> getTriageGroupsForPatientByStation(Patient p,String stationNumber){

		String[] paramNames = new String[] { "patientId","stationNumber" };
		Object[] paramValues = new Object[] { p.getId(),stationNumber};

		Collection<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUPS_FOR_PATIENTS_BY_STATION, paramNames, paramValues );

		return l;
	}


	@SuppressWarnings("unchecked")
	public List<TriageGroup> getTriageGroupsForClinician(Clinician c) {

		String[] paramNames = new String[] { "clinicianId" };
		Object[] paramValues = new Object[] { c.getId()};

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUPS_FOR_CLINICIAN, paramNames, paramValues );

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<TriageGroup> getTriageGroupsForStation(String station){

		String[] paramNames = new String[] { "station" };
		Object[] paramValues = new Object[] { station };

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUPS_FOR_STATION, paramNames, paramValues );

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<TriageGroup> getTriageGroupsAllActive(){

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQuery(
				QRY_TRIAGE_GROUPS_ALL_ACTIVE );

		return l;
	}

	@SuppressWarnings("unchecked")
	public TriageGroup findTriageGroupByName(String name){


		String[] paramNames = new String[] { "name" };
		Object[] paramValues = new Object[] { name };

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TRIAGE_GROUPS_BY_NAME, paramNames, paramValues );

		if (l == null || l.size() == 0) {
			/* no triage group matched */
			return null;
		}

		if(l.size() > 1){
			/* There is a real problem here.
			 * The database constraints should prevent this.
			 */
			//throw new DataIntegrityViolationException("Duplicate triage groups found with given constraints.");
		}

		TriageGroup result = l.get(0);
		result.getClinicians();
		result.getRelations();
		return result;
	}

	@SuppressWarnings("unchecked")
	public TriageGroup findActiveTriageGroupByName(String name){


		String[] paramNames = new String[] { "name" };
		Object[] paramValues = new Object[] { name };

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_ACTIVE_TRIAGE_GROUPS_BY_NAME, paramNames, paramValues );


		if (l == null || l.size() == 0) {
			/* no triage group matched */
			return null;
		}

		TriageGroup result = l.get(0);
		result.getClinicians();
		result.getRelations();
		return result;
	}


	@SuppressWarnings("unchecked")
	public List<Message> getOpenMsgsForTriageGroup(TriageGroup tg) {
		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { tg.getId() };

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				TriageGroupDao.QRY_OPEN_MSGS_FOR_TRIAGE_GROUP, paramNames, paramValues );
	}

	@SuppressWarnings("unchecked")
	public List<Message> getMsgsToNotifyForTriageGroup(TriageGroup tg) {
		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { tg.getId() };

		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				TriageGroupDao.QRY_MSGS_TO_NOTIFY_FOR_TRIAGE_GROUP, paramNames, paramValues );
	}

	@SuppressWarnings("unchecked")
	public List<Message> getAssignedMsgsForTriageGroup(TriageGroup tg, List userList){
		String[] paramNames = new String[] { "triageGroupId","clinicianIdList" };
		Object[] paramValues = new Object[] { tg.getId(), userList  };


		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				TriageGroupDao.QRY_ASSIGNED_MSGS_FOR_TRIAGRE_GROUP, paramNames, paramValues );
	}

	public void fleshRelations(TriageGroup tg){
		getSession().lock(tg, LockMode.NONE);
		getHibernateTemplate().initialize(tg.getRelations());
	}

	@SuppressWarnings("unchecked")
	public List<TriageGroup> getInActiveTriageGroupsForStation(String station){

		String[] paramNames = new String[] { "station" };
		Object[] paramValues = new Object[] { station };

		List<TriageGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_INACTIVE_TRIAGE_GROUPS_FOR_STATION, paramNames, paramValues );

		return l;
	}


	@SuppressWarnings("unchecked")
	public TreeSet<String> getAllActiveSMClinicsCPRSTitles(){
		try{
			List<String> cprsTitlesList = getHibernateTemplate().findByNamedQuery(QRY_GET_ALL_ACTIVE_CPRS_TITLES);

			if(cprsTitlesList!=null)
				return new TreeSet<String>(cprsTitlesList);
			else
				return null;
		}catch(Exception cprsException){

			return null;
		}
	}



	@SuppressWarnings("unchecked")
	public SMClinicsTriageMap getActiveSMClinicByTriageGroup(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { triageGroupId };

		List<SMClinicsTriageMap> clinicTriageMap =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_ACTVE_SMCLINICS_BYTRIAGEGROUP, paramNames, paramValues );

		if(clinicTriageMap!=null && clinicTriageMap.size()!=0){
			return clinicTriageMap.get(0);
		}

		return null ;
	}
	public List<Object[]> getUsersAndSurrogatesForTriageGroup(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { triageGroupId };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_USERS_AND_SURROGATES_FOR_TRIAGEGROUP, paramNames, paramValues );

		return l;
	}

	public List<Object[]> getVisnAndFaciltiyByTriageGroup(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" };
		Object[] paramValues = new Object[] { triageGroupId };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_VISN_AND_FACILITY_BY_TRIAGEGROUP, paramNames, paramValues );

		return l;

	}

	public List<Object[]> getAssociatedSMClinicsByClinicianAndStation(Long stationNumber, Long userId){
		String[] paramNames = new String[] { "stationNumber","userId" };
		Object[] paramValues = new Object[] { stationNumber,userId };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_ASSOCIATED_SM_CLINIS_BY_CLINICIAN_AND_STATIONNUMBER, paramNames, paramValues );

		return l;
	}

	public List<Object[]> getFacilityAdminsEmailsByStation(String stationNumber){
		String[] paramNames = new String[] { "stationNumber" };
		Object[] paramValues = new Object[] { stationNumber};

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_FACILITY_ADMINS_EMAIL_ADDRESS_BY_STATION, paramNames, paramValues );

		return l;

	}

	@SuppressWarnings("unchecked")
	public TriageGroup getTriageGroupAndRelations(Long triageGroupId){

		TriageGroup triageGroup = findById(triageGroupId);
		if (triageGroup == null) {
			/* no triage group matched */
			return null;
		}
		try{
			getSession().lock(triageGroup,LockMode.NONE);
			getHibernateTemplate().initialize(triageGroup.getRelations());

		}catch(Exception eeee){

		}
		return triageGroup;
	}


}