package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.TiuNoteRecordDao;
import gov.va.med.mhv.sm.model.TiuNoteRecord;

public class TiuNoteRecordDaoImpl extends BaseEntityDaoHibernate<TiuNoteRecord, Long> 
	implements TiuNoteRecordDao {

	private static final Log log = LogFactory.getLog(MessageDaoImpl.class);
	
	public TiuNoteRecord getRecord(Long threadId, String vistaDiv){
		
		String[] paramNames = new String[] { "threadId", "vistaDiv" }; 
		Object[] paramValues = new Object[] { threadId, vistaDiv }; 
		
		@SuppressWarnings("unchecked")
		List<TiuNoteRecord> o = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TIU_RECORD_THREAD, paramNames, paramValues );
		
		// the records are returned in DESC order so that we can
		// just return the last record
		if(o.size() > 0)
			return o.get(0);
		
		// no record found
		return null;
		
	}
	
	public List<TiuNoteRecord> getRecords(Long threadId, String vistaDiv){
		
		String[] paramNames = new String[] { "threadId", "vistaDiv" }; 
		Object[] paramValues = new Object[] { threadId, vistaDiv }; 
		
		@SuppressWarnings("unchecked")
		List<TiuNoteRecord> o = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TIU_RECORD_THREADS, paramNames, paramValues );
		
		return o;
		
	}
	
	public TiuNoteRecord getRecord(String conversationId){
		
		String[] paramNames = new String[] { "conversationId" }; 
		Object[] paramValues = new Object[] { conversationId }; 
		
		@SuppressWarnings("unchecked")
		List<TiuNoteRecord> o = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TIU_RECORD_CONVERSATION, paramNames, paramValues );
		
		
		if(o == null || o.size() == 0)
			return null;
		
		return o.get(0);
	}
	
	public List<Object[]> getProgressNotesStatusByThreadId(Long threadId){
		String[] paramNames = new String[] { "threadId" };
		Object[] paramValues = new Object[] { threadId };

		List<Object[]> listObj = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_PROGRESSNOTES_STATUS_BYTHREAD_ID, paramNames, paramValues );

		return listObj;
	}
	
	public TiuNoteRecord getTiuNoteRecordByThreadAndMessageId(Long threadId,Long messageId){
		String[] paramNames = new String[]{ "threadId","messageId"};
		Object[] paramValues = new Object[]{threadId,messageId};
		List<TiuNoteRecord> tiuList = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_TIU_RECORD_BYTHREADANDMESSAGE_ID, paramNames, paramValues );
		if(tiuList!=null && tiuList.size()>=1)
				return tiuList.get(0);
		else
				return null;
	}
	
	public List<Object[]> getFailedCPRSProgressNotesByStation(String stationNumber){
		String[] paramNames = new String[] { "stationNumber" };
		Object[] paramValues = new Object[] { stationNumber };

		List<Object[]> listObj = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_FAILED_CPRS_NOTES_BY_STATIONNUMBER, paramNames, paramValues );

		return listObj;
	}
	
	public Boolean changePreviousTiuNoteRecordStatusByThreadAndMessageId(Long threadId,Long messageId){
		try{
			Object[] paramValues = new Object[] {threadId,messageId};
			Query q = getSession().getNamedQuery(QRY_CHANGE_PREVIOUS_SAVED_NOTES_BY_THREAD_AND_MESSAGE_ID);
			String sql = q.getQueryString();
			getHibernateTemplate().bulkUpdate(sql,paramValues);
			return Boolean.TRUE;
		}catch(Exception e4){
			if(log.isErrorEnabled()){
				log.error("####An Error Occured while  resetting TiuNoteRecord by threadId "+threadId+"and messageId "+messageId+" "+e4);
			}
			return Boolean.FALSE;
		}
	}	
	
}

